#!/bin/bash

# search.sh - Search Gousto recipes by name

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
CACHE_FILE="$SCRIPT_DIR/../data/recipes.json"

if [[ ! -f "$CACHE_FILE" ]]; then
    echo "Error: Recipe cache not found."
    echo "Run ./update-cache.sh first to build the cache."
    exit 1
fi

if [[ $# -eq 0 ]]; then
    echo "Usage: $0 <search term>"
    echo "Example: $0 chicken"
    exit 1
fi

# Build case-insensitive search pattern
query=$(echo "$@" | tr '[:upper:]' '[:lower:]')

echo "Searching for: $query"
echo ""

# Search using jq - case insensitive match on title
results=$(jq --arg q "$query" '
    map(select(.title | ascii_downcase | contains($q)))
' "$CACHE_FILE")

count=$(echo "$results" | jq 'length')

if [[ "$count" -eq 0 ]]; then
    echo "No recipes found matching '$query'"
    exit 0
fi

echo "Found $count recipe(s):"
echo ""

# Display results
echo "$results" | jq -r '.[] | "\(.title)\n  Rating: \(.rating) (\(.rating_count) reviews) | Prep: \(.prep_time) min | Slug: \(.slug)\n"'
