---
name: gousto
description: Search and browse 9,000+ Gousto recipes. Get full ingredients and step-by-step cooking instructions via official API.
homepage: https://github.com/dhruvkelawala/gousto-agent-skill
metadata: {"openclaw":{"emoji":"🍳","requires":{"bins":["curl","jq"]}}}
---

# Gousto Recipe Skill

Search and browse 9,000+ Gousto recipes from the command line.

## Quick Start

```bash
# First time: build the cache (~3 min)
./scripts/update-cache.sh

# Search recipes
./scripts/search.sh chicken
./scripts/search.sh "beef curry"

# Get full recipe with ingredients & steps
./scripts/recipe.sh honey-soy-chicken-with-noodles
```

## Scripts

| Script | Purpose |
|--------|---------|
| `search.sh <query>` | Search recipes by title (uses local cache) |
| `recipe.sh <slug>` | Get full recipe details with ingredients and cooking steps |
| `update-cache.sh` | Rebuild local cache from Gousto API (~3 min) |

## API Details

**Official Gousto API** (recipe listing):
```
https://production-api.gousto.co.uk/cmsreadbroker/v1/recipes?limit=50&offset=0
```
- Returns metadata: title, rating, prep_time, url
- Paginate with `offset` parameter (NOT `skip` — that's broken!)
- ~9,300 recipes total

**Official Gousto API** (single recipe):
```
https://production-api.gousto.co.uk/cmsreadbroker/v1/recipe/{slug}
```
- Full recipe with ingredients, cooking steps, nutritional info
- HTML in steps is stripped to plain text by the script

## Cache Format

`data/recipes.json` — array of objects:
```json
{
  "title": "Chicken Tikka Masala",
  "slug": "chicken-tikka-masala",
  "rating": 4.8,
  "rating_count": 12543,
  "prep_time": 35,
  "uid": "blt123..."
}
```

## Notes

- Cache is gitignored — run `update-cache.sh` after cloning
- Search is instant (local jq filter)
- Recipe fetch requires network (vfjr.dev proxy)
