# 🍳 Gousto Agent Skill

A recipe skill for AI agents to search and retrieve cooking instructions from Gousto's 9,000+ recipe database.

Built for use with [OpenClaw](https://github.com/openclaw/openclaw) / Moltbot / ClawdBot.

## Features

- **Search** 9,000+ recipes by name
- **Get full recipes** with ingredients and step-by-step cooking instructions
- **Fast local cache** for instant search results
- **Official API** — no third-party proxies

## Installation

```bash
git clone https://github.com/dhruvkelawala/gousto-agent-skill.git
cd gousto-agent-skill

# Build the recipe cache (~3 minutes)
./scripts/update-cache.sh
```

## Usage

### Search recipes

```bash
./scripts/search.sh chicken
./scripts/search.sh "beef curry"
./scripts/search.sh mushroom
```

Output:
```
Searching for: mushroom

Found 436 recipe(s):

 Garlic Portobello Mushroom Salad With Goat's Cheese
  Rating: 4.5 (230 reviews) | Prep: 35 min | Slug: garlic-portobello-mushroom-salad
```

### Get full recipe

```bash
./scripts/recipe.sh garlic-portobello-mushroom-salad
```

Returns JSON with:
- Title, rating, prep time
- Full ingredient list with quantities
- Step-by-step cooking instructions
- Basic pantry items needed

## For AI Agents

This skill is designed for AI agent frameworks. The scripts output structured data that agents can parse and present to users.

### OpenClaw Integration

Add to your skills directory:
```bash
cd ~/.openclaw/workspace/skills
git clone https://github.com/dhruvkelawala/gousto-agent-skill.git gousto
cd gousto && ./scripts/update-cache.sh
```

The agent can then:
1. Search recipes with `./scripts/search.sh <query>`
2. Get full recipe with `./scripts/recipe.sh <slug>`

## API Reference

This skill uses the official Gousto API:

| Endpoint | Purpose |
|----------|---------|
| `/cmsreadbroker/v1/recipes?limit=50&offset=N` | List recipes (paginated) |
| `/cmsreadbroker/v1/recipe/{slug}` | Full recipe details |

**Note:** The `skip` parameter is broken in Gousto's API — use `offset` for pagination.

## Files

```
gousto-agent-skill/
├── README.md
├── SKILL.md          # Agent-facing documentation
├── .gitignore
├── data/
│   └── recipes.json  # Local cache (gitignored)
└── scripts/
    ├── search.sh     # Search recipes
    ├── recipe.sh     # Get full recipe
    └── update-cache.sh
```

## License

MIT
