const fs = require('fs');
const http = require('http');
const url = require('url');
const { exec } = require('child_process');

const path = require('path');
const CREDENTIALS_PATH = path.join(__dirname, '../../..', 'credentials.json');
const TOKEN_PATH = path.join(__dirname, '../../..', 'token.json');

// Read credentials
const credentials = JSON.parse(fs.readFileSync(CREDENTIALS_PATH));
const { client_id, client_secret, redirect_uris } = credentials.installed || credentials.web;

// Check if token exists and try to refresh
if (fs.existsSync(TOKEN_PATH)) {
  const token = JSON.parse(fs.readFileSync(TOKEN_PATH));
  
  if (token.refresh_token) {
    console.log('Refreshing token...');
    const https = require('https');
    const postData = new url.URLSearchParams({
      client_id,
      client_secret,
      refresh_token: token.refresh_token,
      grant_type: 'refresh_token'
    }).toString();

    const options = {
      hostname: 'oauth2.googleapis.com',
      path: '/token',
      method: 'POST',
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded',
        'Content-Length': postData.length
      }
    };

    const req = https.request(options, (res) => {
      let data = '';
      res.on('data', (chunk) => { data += chunk; });
      res.on('end', () => {
        const newToken = JSON.parse(data);
        if (newToken.access_token) {
          token.access_token = newToken.access_token;
          token.expiry_date = Date.now() + (newToken.expires_in * 1000);
          fs.writeFileSync(TOKEN_PATH, JSON.stringify(token, null, 2));
          console.log('✅ Token refreshed successfully!');
          process.exit(0);
        } else {
          console.error('❌ Failed to refresh token:', data);
          process.exit(1);
        }
      });
    });

    req.on('error', (e) => {
      console.error('❌ Error refreshing token:', e.message);
      process.exit(1);
    });

    req.write(postData);
    req.end();
    return;
  }
}

// Need full OAuth flow
console.log('Need to authenticate. Starting OAuth flow...');

const SCOPES = ['https://www.googleapis.com/auth/tasks'];
const authUrl = `https://accounts.google.com/o/oauth2/v2/auth?${new url.URLSearchParams({
  client_id,
  redirect_uri: redirect_uris[0],
  response_type: 'code',
  scope: SCOPES.join(' '),
  access_type: 'offline',
  prompt: 'consent'
}).toString()}`;

console.log('\n📋 Authorize this app by visiting:\n');
console.log(authUrl);
console.log('\n');

// Start local server to receive callback
const server = http.createServer(async (req, res) => {
  if (req.url.indexOf('/?code=') > -1) {
    const qs = new url.URL(req.url, 'http://localhost:3000').searchParams;
    const code = qs.get('code');
    
    res.end('✅ Authentication successful! You can close this window.');
    
    // Exchange code for token
    const https = require('https');
    const postData = new url.URLSearchParams({
      code,
      client_id,
      client_secret,
      redirect_uri: redirect_uris[0],
      grant_type: 'authorization_code'
    }).toString();

    const options = {
      hostname: 'oauth2.googleapis.com',
      path: '/token',
      method: 'POST',
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded',
        'Content-Length': postData.length
      }
    };

    const tokenReq = https.request(options, (tokenRes) => {
      let data = '';
      tokenRes.on('data', (chunk) => { data += chunk; });
      tokenRes.on('end', () => {
        const token = JSON.parse(data);
        fs.writeFileSync(TOKEN_PATH, JSON.stringify(token, null, 2));
        console.log('✅ Token saved to', TOKEN_PATH);
        server.close();
        process.exit(0);
      });
    });

    tokenReq.write(postData);
    tokenReq.end();
  }
});

server.listen(3000, () => {
  console.log('Listening on http://localhost:3000');
  // Try to open browser
  const start = process.platform === 'darwin' ? 'open' : process.platform === 'win32' ? 'start' : 'xdg-open';
  exec(`${start} "${authUrl}"`);
});
