# Google Tasks API Setup

## Prerequisites

1. **Python packages:**
   ```bash
   pip install google-auth-oauthlib google-auth-httplib2 google-api-python-client
   ```

2. **OAuth credentials:** `credentials.json` file with OAuth 2.0 client credentials

3. **Test user:** Email must be added as test user in Google Cloud Console if app is in testing mode

## Authentication Flow

### First-time setup

When `token.json` doesn't exist, the script will:
1. Open browser for OAuth authorization
2. User logs in and grants permissions
3. Script receives authorization code
4. Token is saved to `token.json`

### Subsequent runs

When `token.json` exists:
- Script loads existing credentials
- Auto-refreshes if expired (using refresh_token)
- No user interaction needed

## Troubleshooting

### Error 403: access_denied

App is in testing mode and user is not a test user.

**Solution:**
1. Go to Google Cloud Console
2. Navigate to: APIs & Services → OAuth consent screen
3. Add user email under "Test users"
4. Or click "PUBLISH APP" if only for personal use

### Invalid credentials

Delete `token.json` and re-authenticate.

## API Limits

- **Free quota:** 50,000 requests/day
- **Rate limit:** 600 requests per 100 seconds
- No billing required for personal use
