---
name: google-tasks
version: 1.0.0
description: Fetch, display, create, and delete Google Tasks using the Google Tasks API. Use when the user asks to check, view, list, get, add, create, remove, or delete their Google Tasks, to-do lists, or task items. Handles OAuth authentication automatically using bash script with curl and jq.
author: OpenClaw Community
keywords: [google-tasks, tasks, todo, productivity, bash, oauth]
license: MIT
---

# Google Tasks Skill

Manage Google Tasks from all task lists using lightweight bash scripts.

## Quick Start

### View tasks
```bash
bash scripts/get_tasks.sh
```

### Create a task
```bash
# Using default list (configured in google-tasks-config.sh)
bash scripts/create_task.sh "Task title" ["due-date"] ["notes"]

# Specifying list name
bash scripts/create_task.sh "List Name" "Task title" ["due-date"] ["notes"]
```

Examples:
```bash
# Simple task (uses default list)
bash scripts/create_task.sh "Buy groceries"

# Task with due date (uses default list)
bash scripts/create_task.sh "Finish report" "2026-02-10"

# Task with specific list
bash scripts/create_task.sh "Work" "Finish report" "2026-02-10"

# Task with list, due date, and notes
bash scripts/create_task.sh "Personal" "Call mom" "2026-02-05" "Ask about her health"
```

**Default list configuration:**
Edit `google-tasks-config.sh` to set your default list:
```bash
DEFAULT_LIST="Private"  # Change to your preferred default
```

### Delete a task
```bash
bash scripts/delete_task.sh "List Name" <task-number-or-title>
```

Examples:
```bash
# Delete by task number (position in list)
bash scripts/delete_task.sh "Work" 2

# Delete by task title
bash scripts/delete_task.sh "Inbox" "Buy groceries"
```

## Requirements

- `jq` - JSON processor (usually pre-installed)
- `curl` - HTTP client (usually pre-installed)
- Valid `token.json` with OAuth access token
- **Scopes required:** `https://www.googleapis.com/auth/tasks` (read + write)

## First-Time Setup

If `token.json` doesn't exist:

1. User needs OAuth credentials (`credentials.json`) - See [setup.md](references/setup.md)
2. Run the Node.js authentication flow first to generate `token.json`
3. Then the bash script can be used for all subsequent calls

## Output Format

```
📋 Your Google Tasks:

📌 List Name
──────────────────────────────────────────────────
  1. ⬜ Task title (due: YYYY-MM-DD)
     Note: Task notes if present
  2. ⬜ Another task

📌 Another List
──────────────────────────────────────────────────
  (no tasks)
```

## File Locations

- `token.json` - Access/refresh tokens (workspace root)
- `google-tasks-config.sh` - Configuration file (default list setting)
- `scripts/get_tasks.sh` - Bash script to view tasks
- `scripts/create_task.sh` - Bash script to create tasks
- `scripts/delete_task.sh` - Bash script to delete tasks
- `references/setup.md` - Detailed setup guide

## Implementation

The bash script uses:
- Google Tasks REST API directly
- `curl` for HTTP requests
- `jq` for JSON parsing
- Bearer token authentication from `token.json`

No Python dependencies required.

## Troubleshooting

**Token expired:**
```
Error: Invalid credentials
```
Delete `token.json` and re-authenticate.

**Missing jq:**
```
bash: jq: command not found
```
Install jq: `apt-get install jq` or `brew install jq`

For more details, see [setup.md](references/setup.md).
