# Google Sheets API Field Guide (Advanced)

## 1) Auth model choice
- **Service account**: best for server-to-server automation. Must share the spreadsheet with the service account email.
- **OAuth 2.0**: required for end-user access or per-user consent.

## 2) Scopes (least privilege)
- Read-only: `https://www.googleapis.com/auth/spreadsheets.readonly`
- Read/write: `https://www.googleapis.com/auth/spreadsheets`

## 3) Core identifiers
- `spreadsheetId`: from the URL.
- `sheetId`: numeric, used in `batchUpdate` structural requests.
- `range` (A1 notation): e.g. `Sheet1!A1:D10`.

## 4) Endpoint map and common fields
### Data reads
- `spreadsheets.values.get`
  - `spreadsheetId`, `range`, `majorDimension`, `valueRenderOption`, `dateTimeRenderOption`
- `spreadsheets.values.batchGet`
  - `spreadsheetId`, `ranges[]`, `majorDimension`, `valueRenderOption`, `dateTimeRenderOption`

### Data writes
- `spreadsheets.values.update`
  - `spreadsheetId`, `range`, `valueInputOption`, body: `values[][]`, `majorDimension`
- `spreadsheets.values.append`
  - `spreadsheetId`, `range`, `valueInputOption`, `insertDataOption`, body: `values[][]`
- `spreadsheets.values.batchUpdate`
  - `spreadsheetId`, body: `data[]` (each with `range` + `values`), `valueInputOption`

### Structural and formatting
- `spreadsheets.batchUpdate`
  - `spreadsheetId`, body: `requests[]` (e.g. `addSheet`, `deleteSheet`, `updateSheetProperties`, `updateDimensionProperties`, `repeatCell`, `updateBorders`, `mergeCells`, `unmergeCells`)

## 5) Request body patterns (values)
### Update
```json
{
  "range": "Sheet1!A1:B2",
  "values": [["Name","Score"],["Alice",95]]
}
```

### Append
```json
{
  "range": "Sheet1!A:B",
  "values": [["new","row"]]
}
```

### Batch update (values)
```json
{
  "valueInputOption": "USER_ENTERED",
  "data": [
    {"range": "Sheet1!A1:B2", "values": [["a","b"],["c","d"]]},
    {"range": "Sheet1!D1:D2", "values": [[1],[2]]}
  ]
}
```

## 6) Formatting notes
- `repeatCell` updates `userEnteredFormat` fields; be explicit about the fields you change.
- Colors in `userEnteredFormat` use 0..1 float values, not 0..255.
- `mergeCells` requires `sheetId` and grid ranges, not A1 ranges.

## 7) Limits and reliability
- Keep payloads small (Google recommends under 2 MB).
- Handle `429` with exponential backoff.
- Check quota limits for per-minute and per-user caps.

## 8) Official references
- https://developers.google.com/workspace/sheets/api/limits
- https://developers.google.com/workspace/sheets/api/reference/rest/v4/spreadsheets.values/append
- https://developers.google.com/workspace/sheets/api/reference/rest/v4/ValueInputOption
- https://developers.google.com/workspace/sheets/api/reference/rest/v4/spreadsheets/batchUpdate
- https://developers.google.com/workspace/sheets/api/guides/batch
