---
name: google-sheet-api
description: OpenClaw skill that installs a Google Sheets CLI with setup steps and commands for read/write, batch, formatting, and sheet management.
---

# Google Sheets API Skill (Advanced)

## Purpose
Provide a production-ready Google Sheets CLI for OpenClaw. This skill supports data reads/writes, batch operations, formatting, and sheet management with service account authentication.

## Best fit
- You need a repeatable CLI for automation tasks.
- You want JSON-in/JSON-out for pipelines.
- You need more than basic read/write (formatting, sheet ops, batch updates).

## Not a fit
- You must use end-user OAuth consent flows (this skill is service-account focused).
- You only need lightweight, one-off edits.

## One-time setup
1. Create or select a Google Cloud project.
2. Enable the Google Sheets API.
3. Create a service account and download its JSON key.
4. Share target spreadsheets with the service account email.

## Install
```bash
cd google-sheet-api
npm install
```

## Run
```bash
node scripts/sheets-cli.js help
node scripts/sheets-cli.js read <spreadsheetId> "Sheet1!A1:C10"
node scripts/sheets-cli.js append <spreadsheetId> "Sheet1!A:B" '@data.json'
```

You can also use npm:
```bash
npm run sheets -- read <spreadsheetId> "Sheet1!A1:C10"
```

## Credentials
Supported sources (first match wins):
- `GOOGLE_SHEETS_CREDENTIALS_JSON` (inline JSON string)
- `GOOGLE_SERVICE_ACCOUNT_KEY` (file path)
- `GOOGLE_SHEETS_KEY_FILE` (file path)
- `GOOGLE_APPLICATION_CREDENTIALS` (file path)
- `./service-account.json`, `./credentials.json`, `./google-service-account.json`
- `~/.config/google-sheets/credentials.json`

## Input conventions
- JSON values can be inline or loaded from file using `@path`.
- Write/append expect a 2D array of values.

Example `data.json`:
```json
[["Name","Score"],["Alice",95]]
```

## Command map (high level)
Data:
- `read`, `write`, `append`, `clear`, `batchGet`, `batchWrite`

Formatting:
- `format`, `getFormat`, `borders`, `merge`, `unmerge`, `copyFormat`

Layout:
- `resize`, `autoResize`, `freeze`

Sheets:
- `create`, `info`, `addSheet`, `deleteSheet`, `renameSheet`

Advanced:
- `batch` (raw `spreadsheets.batchUpdate` requests)

## Operational guidance
- Prefer read-only scope for read workflows when possible.
- Add retry with exponential backoff for `429` and transient `5xx` errors.
- Keep request payloads small to avoid limit issues.

## Expected output
- JSON to stdout; non-zero exit code on errors.

## Security notes
- Never log or commit service account keys.
- Share spreadsheets only with the service account email required by this skill.
