# App Store Optimization — Google Play Store

## Ranking Factors

| Factor | Weight | Your Control |
|--------|--------|--------------|
| Keyword relevance | High | Full |
| Download velocity | High | Partial |
| Ratings & reviews | High | Partial |
| Retention | Medium | Full |
| Crash rate | Medium | Full |
| Update frequency | Low | Full |

## Store Listing Elements

### Title (30 characters max)

**Structure:** Primary Keyword + Brand

| Good | Bad |
|------|-----|
| Task Manager - TodoFlow | TodoFlow: The Best Task Manager App |
| Photo Editor Pro | Photo App |
| Budget Tracker - MoneyWise | MW Budget |

**Tips:**
- Put main keyword first
- Include brand for recognition
- Use full 30 characters
- Test with A/B experiments

### Short Description (80 characters max)

First 2 lines visible without expansion. Must hook immediately.

**Structure:** Value prop + key feature + differentiator

```
Track expenses effortlessly. Smart categories, instant insights, no ads.
```

**Checklist:**
- [ ] Main keyword included
- [ ] Clear value proposition
- [ ] Differentiator from competitors
- [ ] No wasted words

### Full Description (4000 characters max)

**Structure:**
```
[Opening hook with main keyword - 2 lines]

[Key Features section - bullets]
★ Feature 1 - benefit
★ Feature 2 - benefit
★ Feature 3 - benefit

[Detailed paragraphs - keyword rich]

[Social proof - awards, press, numbers]

[Call to action]
```

**Keyword strategy:**
- Main keyword: 3-5 times naturally
- Secondary keywords: 2-3 times each
- Long-tail phrases in features
- Update quarterly based on Search Console

### Screenshots (up to 8 per device type)

| Position | Purpose | Best Practice |
|----------|---------|---------------|
| 1-2 | Hook | Best features, bold text |
| 3-4 | Features | Core functionality |
| 5-6 | Social proof | Reviews, awards, numbers |
| 7-8 | Details | Additional features |

**Requirements:**
- Phone: 16:9 or 9:16, min 320px, max 3840px
- Tablet 7": Same ratios
- Tablet 10": Same ratios

**Best practices:**
- Device frames optional but professional
- Bold headlines on each screenshot
- Consistent visual style
- Show real UI, not mockups
- Localize for major markets

### Feature Graphic (1024x500 required)

This appears in browse results and feature placements.

**Design rules:**
- No text smaller than 24pt
- Brand name prominent
- Don't rely on bottom 1/3 (gets cropped)
- Test at thumbnail size
- Avoid excessive text

### Video (optional, 30s-2min)

| Element | Recommendation |
|---------|----------------|
| Length | 30-60 seconds optimal |
| Hook | First 5 seconds critical |
| Format | Landscape, YouTube hosted |
| Content | Real app usage, not animations |
| Audio | Optional, caption if used |

## A/B Testing

### What to Test

| Element | Impact | Test Duration |
|---------|--------|---------------|
| Icon | High | 7 days |
| Screenshots | High | 7 days |
| Short description | Medium | 7 days |
| Feature graphic | Medium | 7 days |

### How to Run

1. Console → Store presence → Store listing experiments
2. Create experiment
3. Set variants (up to 3)
4. Choose traffic split
5. Run for 7+ days
6. Apply winner

### Metrics to Watch

| Metric | Good | Action if Bad |
|--------|------|---------------|
| First-time installers | > baseline | Keep variant |
| Store listing visitors | > baseline | Check keywords |
| Retained installers | > baseline | Fix onboarding |

## Keyword Research

### Tools

| Tool | Use For |
|------|---------|
| Play Console Search | Your actual search terms |
| AppTweak/Sensor Tower | Competitor keywords |
| Google Trends | Seasonal patterns |
| Google Ads Keyword Planner | Search volume |

### Process

1. **Seed list:** Features, use cases, problems solved
2. **Competitor scan:** Top 10 apps' descriptions
3. **Volume check:** Verify search volume
4. **Difficulty:** Can you rank? (smaller apps target long-tail)
5. **Implement:** Title > Short > Full description

### Refresh Cadence

| Element | Frequency |
|---------|-----------|
| Full description | Quarterly |
| Short description | Quarterly |
| Keywords analysis | Monthly |
| Screenshots | Every major feature |

## Localization

### Priority Markets

| Tier | Markets | Why |
|------|---------|-----|
| 1 | US, UK, India | Volume |
| 2 | Germany, Japan, Korea | High LTV |
| 3 | Brazil, Mexico, Indonesia | Growth |

### What to Localize

| Element | Priority |
|---------|----------|
| Title | Must |
| Short description | Must |
| Screenshots | Should |
| Full description | Should |
| Video | Nice to have |

### Localization Tips

- Don't just translate, localize
- Adjust screenshots for cultural context
- Research local competitors
- Local keyword research per market
- Native speakers for review
