---
name: google-photos
description: Manage Google Photos library. Upload photos, create albums, and list library content. Use when the user wants to backup, organize, or share images via Google Photos.
metadata: {"openclaw":{"emoji":"📸","requires":{"apis":["photoslibrary.googleapis.com"]}}}
---

# Google Photos

This skill provides a way to interact with Google Photos Library API to automate photo management.

## Setup

1. **Enable API**: Enable the "Google Photos Library API" in your Google Cloud Console project.
2. **Credentials**: Download your OAuth 2.0 Client ID credentials as `credentials.json`.
3. **Environment**: This skill uses a Python virtual environment located in its folder.

## Usage

All commands are run through the `scripts/gphotos.py` script.

### List Albums
Useful for finding the ID of an existing album.
```bash
./scripts/gphotos.py --action list --credentials /path/to/credentials.json --token /path/to/token.pickle
```

### Create a New Album
```bash
./scripts/gphotos.py --action create --title "Vacations 2026" --credentials /path/to/credentials.json --token /path/to/token.pickle
```

### Upload a Photo
You can optionally specify an `--album-id` to add the photo to a specific album.
```bash
./scripts/gphotos.py --action upload --photo "/path/to/image.jpg" --album-id "ALBUM_ID" --credentials /path/to/credentials.json --token /path/to/token.pickle
```

## Privacy & Security

- This skill only has access to photos it uploads or that are explicitly shared with the application.
- Credentials and tokens are stored locally and should be kept secure.
- Never share your `credentials.json` or `token.pickle` files.
