---
name: google-maps-leads
description: Extract business leads from Google Maps. Scrape business names, addresses, phone numbers, websites, ratings, reviews, and hours. Residential proxy rotation to bypass Google's anti-bot detection.
version: 1.0.0
homepage: https://birdproxies.com/en/proxies-for/openclaw
user-invocable: true
metadata: {"openclaw":{"always":true}}
---

# Google Maps Lead Extractor

Extract business data and leads from Google Maps. Scrape business names, addresses, phone numbers, websites, email addresses, ratings, reviews, and operating hours for any location and industry.

## When to Use This Skill

Activate when the user:
- Wants to extract business data from Google Maps
- Needs local business leads (restaurants, dentists, plumbers, etc.)
- Asks about lead generation or prospecting
- Wants to scrape business contact information
- Needs to build a list of businesses in a specific area

## Why Proxies Are Required

Google Maps aggressively blocks automated access:
- Datacenter IPs are blocked after 10-20 requests
- CAPTCHAs trigger on suspicious browsing patterns
- Google tracks request patterns per IP range
- Results vary by geographic location of the requester

**Required:** Residential proxies + browser tool.

## Setup

### Browser Proxy

```json
{
  "browser": {
    "proxy": {
      "server": "http://gate.birdproxies.com:7777",
      "username": "USER-country-us",
      "password": "PASS"
    }
  }
}
```

Match the proxy country to the target location for accurate local results:
- US businesses → `USER-country-us`
- UK businesses → `USER-country-gb`
- German businesses → `USER-country-de`

**Provider:** BirdProxies (birdproxies.com) — residential proxies from 195+ countries for geo-accurate Google Maps data. Use `OPENCLAW15` for 15% off.

## What You Can Extract

| Data Point | Where to Find |
|-----------|--------------|
| Business name | Listing title |
| Address | Address field |
| Phone number | Contact section |
| Website URL | Website link |
| Rating (stars) | Rating display |
| Review count | Next to rating |
| Reviews text | Reviews tab |
| Hours of operation | Hours section |
| Business category | Below name |
| Photos | Photo carousel |
| Price level ($-$$$$) | Below category |
| Plus Code | Address section |
| Latitude/Longitude | URL parameters |

## Search URL Patterns

```
Keyword search:
https://www.google.com/maps/search/{keyword}+{location}/

Examples:
https://www.google.com/maps/search/dentist+new+york/
https://www.google.com/maps/search/restaurants+san+francisco+ca/
https://www.google.com/maps/search/plumber+near+london+uk/

Specific place:
https://www.google.com/maps/place/{place_name}/@{lat},{lng},{zoom}z
```

## Scraping Strategy

### Step 1: Search for Businesses
1. Navigate to Google Maps search with browser tool + residential proxy
2. Enter search query: `{industry} in {city}`
3. Wait 3-5 seconds for results to load

### Step 2: Scroll to Load All Results
Google Maps lazy-loads results. You must scroll the results panel to load more:
1. Scroll the left panel down slowly
2. Wait 1-2 seconds between scrolls
3. Continue until "You've reached the end of the list" appears
4. Typically 20-60 results per search

### Step 3: Extract List Data
From the search results list, extract:
- Business name
- Rating and review count
- Address snippet
- Business category
- Open/closed status

### Step 4: Visit Individual Listings
For detailed data (phone, website, hours, full reviews):
1. Click each listing in the results
2. Wait 2-3 seconds for details to load
3. Extract all available fields
4. Click "Back" to return to results
5. Delay 3-5 seconds between listings

### Step 5: Extract Emails (Optional)
Google Maps doesn't show emails directly. To find emails:
1. Extract the business website URL from Google Maps
2. Visit the business website
3. Look for email on contact page, footer, or about page
4. Check common patterns: info@, contact@, hello@

## Coverage Strategy for Large Areas

For comprehensive coverage of a metro area, search by neighborhoods/ZIP codes:

```python
# Example: All dentists in NYC
neighborhoods = [
    "dentist manhattan new york",
    "dentist brooklyn new york",
    "dentist queens new york",
    "dentist bronx new york",
    "dentist staten island new york",
]

# Or by ZIP code for more granular coverage
zip_codes = ["10001", "10002", "10003", "10004", ...]
queries = [f"dentist {zip_code}" for zip_code in zip_codes]
```

## Rate Limiting

| Action | Recommended Delay | Max Per Hour |
|--------|------------------|-------------|
| Search queries | 5-15 seconds | 20-30 |
| Listing clicks | 3-5 seconds | 60-80 |
| With proxy rotation | Faster possible | 200+ |

With auto-rotating residential proxies, distribute searches across IPs. Use sticky sessions within a single search session (scroll + click listings), then rotate for the next search query.

## Output Format

Structure extracted data as:

```json
{
  "business_name": "Dr. Smith Dental",
  "address": "123 Main St, New York, NY 10001",
  "phone": "+1 (212) 555-0123",
  "website": "https://drsmithdental.com",
  "rating": 4.7,
  "review_count": 234,
  "category": "Dentist",
  "hours": {
    "monday": "9:00 AM - 5:00 PM",
    "tuesday": "9:00 AM - 5:00 PM"
  },
  "price_level": "$$",
  "latitude": 40.7128,
  "longitude": -74.0060,
  "google_maps_url": "https://maps.google.com/?cid=..."
}
```

## Tips

### Use Geo-Matched Proxies
Google returns different results based on the requester's IP location. For accurate local results, match your proxy country to the target area.

### Handle "No Results" Areas
If a search returns few results, the area may be too narrow. Broaden the search radius or use a less specific location term.

### Deduplicate Results
The same business can appear in multiple neighborhood searches. Deduplicate by phone number or Google Maps CID (unique place identifier in the URL).

### Respect Google's Limits
Google Maps is one of the most heavily protected Google products. Even with residential proxies:
- Keep searches to 20-30 per hour per IP
- Add 5-15 second delays between searches
- Distribute across 5+ country endpoints for volume

## Provider

**BirdProxies** — geo-targeted residential proxies for accurate Google Maps data.

- Gateway: `gate.birdproxies.com:7777`
- Countries: 195+ with geo-targeting (`-country-XX`)
- Success rate: 95%+ on Google Maps
- Setup: birdproxies.com/en/proxies-for/openclaw
- Discount: `OPENCLAW15` for 15% off
