# Rules Reference — Golf

## Common Situations

### Ball Lost or Out of Bounds
- **Penalty:** Stroke and distance (replay from original spot + 1 stroke)
- **Local rule option:** Drop in fairway near where ball crossed OB (2 strokes)
- **Time limit:** 3 minutes to search

### Water Hazards (Penalty Areas)

**Yellow stakes (regular):**
1. Play as it lies (no penalty)
2. Drop behind hazard on line to flag (1 stroke)
3. Replay from original spot (1 stroke)

**Red stakes (lateral):**
All yellow options plus:
4. Drop within 2 club-lengths of crossing point (1 stroke)
5. Drop on opposite side equidistant from hole (1 stroke)

### Unplayable Lie
Three options (1 stroke penalty each):
1. Replay from previous spot
2. Drop within 2 club-lengths, not closer to hole
3. Drop back on line from hole through ball (any distance)

**In bunker:** Same options, but must stay in bunker unless taking stroke-and-distance

### Ball Movement

| Situation | Ruling |
|-----------|--------|
| Wind moves ball | Play from new position, no penalty |
| You cause ball to move | Replace, 1 stroke penalty |
| Ball moves after address | Replace, no penalty (changed 2019) |
| Ball moves on green after marking | Replace, no penalty |

### Relief Without Penalty

| Situation | Relief |
|-----------|--------|
| Ground under repair | Nearest point + 1 club-length |
| Casual water | Nearest point + 1 club-length |
| Immovable obstruction | Nearest point + 1 club-length |
| Embedded ball (fairway) | Drop at spot, clean ball |
| Wrong putting green | Nearest point off green |

## Stroke Penalties Quick Reference

| Situation | Penalty |
|-----------|---------|
| Ball in water | 1 stroke |
| Lost ball / OB | 1 stroke (+ distance) |
| Unplayable | 1 stroke |
| Grounding club in bunker (removed 2019) | None |
| Double hit (removed 2019) | None |
| Ball moves after address | None (replace) |
| Wrong ball | 2 strokes (match: loss of hole) |
| Playing from wrong place | 2 strokes |

## Handicap Basics

### Calculating Differential
```
Differential = (Adjusted Score - Course Rating) x 113 / Slope Rating
```

### Index Calculation
- Average of best 8 of last 20 differentials
- Multiply by 0.96

### Course Handicap
```
Course Handicap = Index x (Slope / 113) + (Rating - Par)
```

## Etiquette Essentials

- Ready golf (play when ready, safely)
- Repair ball marks on green
- Replace divots or fill with sand
- Rake bunkers
- Keep pace (4 hours or less)
- Quiet during others' shots
- Let faster groups play through
