---
name: goal-setting-okrs
description: Set and track goals for a solopreneur business using OKRs (Objectives and Key Results) and related frameworks. Use when defining business goals, creating quarterly or annual targets, building KPIs, tracking progress, or aligning daily work with strategic direction. Covers OKR methodology adapted for solo operators, goal hierarchy (vision → annual → quarterly → weekly), and review cadences. Trigger on "set goals", "OKRs", "business goals", "quarterly goals", "KPIs", "goal setting", "how to track progress", "annual goals", "prioritize my work", "what should I focus on".
---

# Goal Setting with OKRs

## Overview
OKRs (Objectives and Key Results) were designed for large companies, but the core idea is brutally useful for solopreneurs: set a bold, inspiring objective, then define 2-3 measurable results that prove you hit it. This playbook adapts OKRs for a one-person business — simpler, faster, and directly tied to your daily work.

---

## The Goal Hierarchy

Goals exist at multiple levels. Each level informs the one below it. If you only set goals at one level, you either drift strategically or get lost in tactics.

```
VISION (lifetime / 5-10 years)
  ↓ informs
ANNUAL GOALS (12 months)
  ↓ broken into
QUARTERLY OKRs (3 months)
  ↓ broken into
MONTHLY PRIORITIES (top 3 things this month)
  ↓ broken into
WEEKLY TASKS (what you actually do each week)
```

This playbook builds from the top down.

---

## Step 1: Define Your Vision (Once, Revisit Yearly)

Your vision is not a goal — it has no deadline and no metric. It is the direction you're heading. One or two sentences max.

**Examples:**
- "Build a business that gives me financial freedom and creative autonomy while helping freelancers work more efficiently."
- "Become the go-to automation consultant for mid-stage SaaS companies, building a portfolio that speaks for itself."

**Write it down. Put it somewhere you see it daily.** Every goal you set below should move you toward this vision or be cut.

---

## Step 2: Set Annual Goals (Once Per Year)

Annual goals are bigger and bolder than quarterly OKRs. They set the direction for the entire year. 3-5 annual goals max.

**Format:**
```
ANNUAL GOAL: [Bold, inspiring statement of what you want this year]
WHY IT MATTERS: [How this connects to your vision]
ROUGH SUCCESS METRIC: [What does "done" look like at year end?]
```

**Example:**
```
ANNUAL GOAL: Grow Khatri Automations to $120K revenue
WHY IT MATTERS: Proves the consulting model is sustainable and funds product development
ROUGH SUCCESS METRIC: Total invoiced revenue ≥ $120K by Dec 31
```

Annual goals are not OKRs yet. They are the north stars that quarterly OKRs serve.

---

## Step 3: Write Quarterly OKRs

This is the core of the system. Each quarter, write 2-3 OKRs that together move you toward annual goals.

**OKR structure:**
```
OBJECTIVE: [Bold, qualitative statement. Inspiring. Slightly ambitious — not guaranteed.]

KEY RESULT 1: [Measurable. Binary or percentage. You hit it or you don't.]
KEY RESULT 2: [Measurable.]
KEY RESULT 3: [Measurable. Optional — 2 is fine if they're strong.]
```

**Key Result rules:**
- Must be measurable. "Improve marketing" fails. "Publish 12 tutorials with avg 500+ views each" passes.
- Ambitious but not impossible. Aim to hit 70-80% on average. 100% every quarter = targets too easy.
- Things YOU mostly control. "Get 50 customers" is partly yours. "Go viral" is mostly not.

**Example OKR:**
```
OBJECTIVE: Establish thought leadership in the n8n automation space

KEY RESULT 1: Publish 12 in-depth automation tutorials (1/week), avg 500+ views each
KEY RESULT 2: Grow LinkedIn followers from 800 to 1,200
KEY RESULT 3: Get mentioned or linked by 3 external blogs or newsletters
```

**Solopreneur limit:** 2-3 OKRs per quarter max. More = nothing gets focus. If you have 5 important things, pick the 2-3 that matter most THIS quarter. The others wait.

---

## Step 4: Monthly Priorities (Top 3)

At the start of each month, look at your quarterly OKRs and ask: "What are the 3 most important things I can do THIS MONTH to move these forward?"

```
MONTH: [Month]

TOP 3 PRIORITIES:
  1. [Specific, actionable. Tied to a Key Result.]
  2. [Specific, actionable. Tied to a Key Result.]
  3. [Specific, actionable. Tied to a Key Result.]

EVERYTHING ELSE IS SECONDARY. Hit these 3 = successful month.
```

**This is your filter.** New task or opportunity comes in? Check: does it serve one of these 3? If not, it waits or it replaces one (only if it's genuinely more important).

---

## Step 5: Weekly Planning (15 min, Sunday or Monday)

Translate monthly priorities into concrete tasks for the week.

```
WEEK OF: [dates]

FROM PRIORITY 1: [1-2 tasks]
FROM PRIORITY 2: [1-2 tasks]
FROM PRIORITY 3: [1-2 tasks]

TOTAL: 5-8 tasks max. More = not realistic for one person.
```

**Time-block every task.** Assign it to a specific day and time slot. Unscheduled tasks don't get done. No one is holding you accountable except your calendar.

---

## Step 6: Review Cadences

Reviews are where learning happens. Without them, OKRs are a document you wrote in January and forgot.

**Weekly (Friday, 5 min):**
- Tasks completed vs. planned?
- Why did anything slip?
- What's next week's list?

**Monthly (last day, 15 min):**
- Hit the top 3 priorities?
- OKR Key Results — on pace / behind / ahead?
- Adjust anything for next month?

**Quarterly (end of quarter, 1 hour):**
- Score each Key Result: 0-100%. Aim for 70-80% average.
- What worked? What didn't? Lessons?
- Write new OKRs for next quarter.
- Are OKRs still aligned to annual goals, or has the annual goal shifted?

**Annual (once, 2 hours):**
- Annual goals hit? By how much?
- Has your vision evolved?
- New annual goals for the coming year.

---

## OKR Mistakes to Avoid
- Key Results that are activities, not outcomes. "Write blog posts" = activity. "Grow organic traffic 30%" = outcome.
- Too many OKRs. Two strong beats five weak.
- Never reviewing. OKRs without reviews are just wishes on paper.
- Punishing yourself for missing targets. OKRs are calibrated to be ambitious. Missing 30% is normal. Reviews are for learning, not guilt.
- Abandoning OKRs when business gets busy. That's exactly when they matter most — they keep you strategic instead of reactive.
