---
name: go-to-market
description: Build a go-to-market (GTM) strategy for launching a product or entering a new market. Use when planning how to reach customers, position your product, choose channels, set pricing, and execute launch. Covers market entry strategy, customer segmentation, positioning, channel strategy, and GTM execution plan. Trigger on "go-to-market", "GTM strategy", "market entry", "launch strategy", "how to reach customers", "GTM plan".
---

# Go-to-Market Strategy

## Overview
A go-to-market (GTM) strategy is your plan for how you'll reach customers and generate revenue. It answers: Who's the customer? What's the message? How will you reach them? How will you sell? For solopreneurs, a sharp GTM strategy prevents wasted effort on channels or messages that don't work. This playbook builds a GTM plan that drives customer acquisition efficiently.

---

## Step 1: Define Your Target Customer (ICP)

Before you can go to market, you need to know exactly who you're selling to. A vague target = wasted marketing spend.

**ICP (Ideal Customer Profile) template:**
```
DEMOGRAPHICS (if B2C):
  Age range, income, location, job type

FIRMOGRAPHICS (if B2B):
  Industry, company size, revenue range, location

PSYCHOGRAPHICS:
  Pain points, goals, values, fears

BEHAVIORAL:
  Where they hang out (online/offline)
  How they make buying decisions
  What triggers them to look for a solution like yours
```

**Example (B2B SaaS):**
```
ICP: Small SaaS founders (solo or 2-5 person teams)
  Industry: B2B SaaS
  Company size: Pre-seed to seed stage, $0-$500K ARR
  Pain: Spending 15+ hours/week on manual ops work (billing, support, reporting)
  Goal: More time to focus on product and growth
  Hangouts: Indie Hackers, Twitter, Y Combinator forums
  Buying trigger: Hitting $50K ARR and realizing ops is taking over
```

**Validation:** Interview 5-10 people who match your ICP. Ask about their pain, current solutions, and what would make them switch. If their answers don't align with your assumptions, refine your ICP.

---

## Step 2: Craft Your Positioning

Positioning is how you want customers to think about your product. It's the foundation of all your messaging.

**Positioning statement template (internal, not customer-facing):**
```
For [target customer],
Who [has this problem],
[Your product] is a [category]
That [key benefit / unique value].
Unlike [competitors or alternatives],
[Your product] [key differentiator].
```

**Example:**
```
For solo SaaS founders,
Who waste hours on manual operational tasks,
AutomateOps is a no-code automation platform
That saves 15+ hours per week on billing, support, and reporting.
Unlike Zapier or Make,
AutomateOps is purpose-built for SaaS workflows with pre-built templates.
```

**Why this matters:** This statement guides every piece of marketing copy, sales messaging, and product positioning. When in doubt, return to this.

**Test your positioning:** Can you explain it in 1-2 sentences? If someone hears it, do they immediately understand who it's for and why it's different? If not, simplify.

---

## Step 3: Choose Your GTM Motion (How You'll Sell)

Different products require different sales motions. Pick based on your price point and customer complexity.

**GTM motion types:**

| Motion | When to Use | Characteristics |
|---|---|---|
| **Product-Led (PLG)** | Low price ($0-$100/month), self-serve | Free trial or freemium, users sign up and onboard themselves, minimal or no sales involvement |
| **Sales-Led** | High price ($500+/month or $5K+ deal), complex | Demos, proposals, human touch, longer sales cycles |
| **Hybrid** | Mid-market ($100-500/month) | Self-serve for small customers, sales assist for larger ones |
| **Community-Led** | When network effects or peer influence matters | Build a community first (Slack, Discord, forum), monetize through the community |

**Selection guide:**
- If your product is simple and cheap → Product-Led
- If your product is complex or expensive → Sales-Led
- If your product benefits from user interaction → Community-Led
- If you serve both SMB and enterprise → Hybrid

**Example (Solopreneur SaaS):**
- Price: $49/month → Product-Led GTM
- Execution: Free 14-day trial, self-serve signup, onboarding via email + in-app tips, upgrade prompts in-app

---

## Step 4: Select Your Channels

Channels are how you reach your target customer. Don't try to be everywhere — pick 2-3 channels and dominate them.

**Channel selection framework:**

| Channel | Best For | Time to ROI | Cost |
|---|---|---|---|
| **SEO/Content** | High-intent searches, long-term growth | 3-6 months | Low (time) |
| **Paid Ads** (Google, Facebook, LinkedIn) | Fast traffic, testing, scaling | Immediate | High ($$$) |
| **Social Media** (LinkedIn, Twitter, Instagram) | Building audience, brand awareness | 1-3 months | Low (time) |
| **Email Marketing** | Owned audience, nurturing leads | Immediate (if you have a list) | Low |
| **Community / Forums** | Niche audiences, trust-building | 1-6 months | Low (time) |
| **Partnerships / Affiliates** | Leveraging others' audiences | 1-3 months | Medium (rev share) |
| **Outreach** (Cold email, LinkedIn DMs) | B2B, direct targeting | Immediate | Low (time) |
| **Product Hunt / Directories** | Tech/SaaS products, launch spike | Immediate | Low |

**How to choose:**
1. **Where does your ICP hang out?** If they're on LinkedIn, go there. If they search Google, do SEO.
2. **What's your budget?** If $0, focus on organic (SEO, social, community). If $1K+/month, test paid ads.
3. **What's your timeline?** If you need customers this month, use outreach or paid ads. If you can wait 6 months, build SEO.

**Recommended solopreneur stack (choose 2-3):**
- **B2B SaaS:** SEO + LinkedIn + Cold Outreach
- **B2C Product:** Instagram/TikTok + Paid Ads + Email
- **Service/Consulting:** LinkedIn + Cold Outreach + Referrals
- **Info Product:** Email + Twitter + YouTube

**Rule:** Pick 2 primary channels. Master them before adding a third.

---

## Step 5: Build Your GTM Execution Plan

Strategy without execution is just ideas. Build a 90-day GTM plan with specific tactics, owners (you), and metrics.

**90-Day GTM Plan Template:**

```
GOAL: [What you want to achieve in 90 days — revenue, users, leads?]
  Example: Acquire 50 paying customers at $49/month = $2,450 MRR

CHANNEL 1: [Primary channel]
  Tactic 1: [Specific action]
    Metric: [How you'll measure]
    Owner: [You]
    Timeline: [Weeks 1-4, 5-8, 9-12]

  Tactic 2: [Specific action]
    Metric: [How you'll measure]
    Owner: [You]
    Timeline: [Weeks 1-4, 5-8, 9-12]

CHANNEL 2: [Secondary channel]
  [Same structure]

SALES/CONVERSION:
  Tactic: [How you'll convert leads to customers]
  Metric: [Conversion rate target]
```

**Example (B2B SaaS, Product-Led GTM):**
```
GOAL: 50 paying customers in 90 days = $2,450 MRR

CHANNEL 1: SEO
  Tactic 1: Publish 12 blog posts targeting low-competition keywords
    Metric: 2,000 organic visitors/month by Week 12
    Timeline: 1 post/week, Weeks 1-12

  Tactic 2: Build 3 content clusters around top pain points
    Metric: 5 posts ranking in top 10 by Week 12
    Timeline: Weeks 1-12

CHANNEL 2: Cold Outreach
  Tactic 1: Send 500 personalized LinkedIn messages to ICP
    Metric: 15% reply rate, 25 demo bookings
    Timeline: 50 messages/week, Weeks 1-10

CONVERSION:
  Tactic: Free 14-day trial with onboarding email sequence
    Metric: 25% trial-to-paid conversion rate
    Timeline: Ongoing
```

**Weekly check-in:** Review metrics. Are you on track? If not, what needs to change?

---

## Step 6: Set Your Pricing and Offer

Pricing is part of your GTM strategy. The right price can accelerate adoption; the wrong price kills momentum.

**Pricing considerations:**
- What's the value you deliver? (See pricing-strategy skill)
- What are competitors charging?
- What's your target CAC (Customer Acquisition Cost)?
- Do you want to optimize for volume (lower price) or margin (higher price)?

**Launch offer (optional but effective):**
- Early-bird discount (20-30% off for first 100 customers)
- Lifetime deal (one-time payment for lifetime access — good for cash flow, bad for MRR)
- Free tier or trial (reduces friction, increases signups)

**Rule:** Don't underprice to "get customers fast." Cheap customers are often low-quality and high-churn. Price at the value you deliver.

---

## Step 7: Measure and Iterate

GTM is not set-it-and-forget-it. Track performance and adjust every 30 days.

**Metrics to track:**

| Metric | What It Tells You | Where to Track |
|---|---|---|
| **Customer Acquisition Cost (CAC)** | How much you're spending to acquire one customer | Marketing spend / new customers |
| **Conversion rate** | % of leads/visitors that become customers | Analytics + CRM |
| **Channel ROI** | Which channels are profitable | Revenue per channel / spend per channel |
| **Time to first customer** | How long it takes from launch to first sale | Manual tracking |
| **Customer feedback** | Are you solving the right problem? | Surveys, interviews, support tickets |

**Monthly GTM review (30 min):**
1. Did you hit your 90-day goal milestones for the month?
2. Which channels performed best? (highest ROI, lowest CAC)
3. Which channels underperformed? (high spend, low return)
4. What should you double down on? What should you cut?
5. What did you learn about your ICP or positioning?

**Iteration:** Every 30 days, adjust your tactics. If a channel isn't working after 30 days, pivot or cut it. If a channel is crushing, put more resources there.

---

## GTM Mistakes to Avoid
- **Not defining ICP clearly.** "Everyone" is not a target customer. Narrow it down.
- **Trying too many channels at once.** Spreading thin = mediocre everywhere. Pick 2-3 max.
- **Launching without positioning.** If you don't know how you're different, customers won't either.
- **Not tracking metrics.** You can't improve what you don't measure. Set up analytics before launch.
- **Giving up too early.** Most channels take 30-90 days to show results. Don't panic after Week 1.
- **Ignoring customer feedback.** If customers tell you your messaging is confusing or the pricing is off, listen and adjust.
