---
name: go-security-vulnerability
description: "Identify, assess, and fix security vulnerabilities in Go modules using govulncheck. Handle common vulnerabilities like JWT issues and ensure application stability during fixes."
metadata:
  {
    "openclaw":
      {
        "emoji": "🔒",
        "requires": { "bins": ["go"] },
        "install":
          [
            {
              "id": "golang",
              "kind": "script",
              "script": "curl -L https://golang.org/dl/go1.21.5.linux-amd64.tar.gz | tar -C /usr/local -xzf -",
              "bins": ["go"],
              "label": "Install Go",
            },
          ],
      },
  }
---

# Go Security Vulnerability Skill

Use Go tooling to identify, assess, and fix security vulnerabilities in Go modules. This skill helps detect and remediate vulnerabilities while maintaining application functionality.

## Vulnerability Detection

Scan for vulnerabilities in your Go project:

```bash
go install golang.org/x/vuln/cmd/govulncheck@latest
govulncheck ./...
```

Check specific modules for known vulnerabilities:

```bash
govulncheck -show verbose ./...
```

## Assessment Process

1. **Identify Affected Packages**: Determine which dependencies contain vulnerabilities
2. **Check Severity**: Review the CVE details and potential impact
3. **Verify Usage**: Confirm if the vulnerable functions are actually used in your code
4. **Plan Remediation**: Choose the appropriate fix strategy

## Common Fix Strategies

### Direct Dependency Update
Update vulnerable packages to secure versions:

```bash
go get -u vulnerable/package@latest
go mod tidy
```

### Transitive Dependency Handling
For vulnerabilities in transitive dependencies:

```bash
go mod why vulnerable/package  # Understand why it's included
go mod edit -replace vulnerable/package=newer-version  # Replace if needed
go mod tidy
```

### Removal Strategy
If a dependency is unused or can be replaced:

1. Remove direct imports of the vulnerable code
2. Run `go mod tidy` to clean up unused dependencies
3. Verify application functionality remains intact

## Verification Steps

After applying fixes:

```bash
# Verify no vulnerabilities remain
govulncheck ./...

# Ensure application still builds
go build ./...

# Run tests to verify functionality
go test ./...
```

## Common Vulnerabilities

### JWT Libraries
- Issue: `github.com/golang-jwt/jwt` GO-2025-3553 (excessive memory allocation)
- Fix: Update to newer version or switch to `golang.org/x/oauth2` alternatives

### Standard Library Updates
- Keep Go version updated for security patches
- Run `go vuln` to check for stdlib vulnerabilities

## Best Practices

- Regularly scan dependencies with `govulncheck`
- Keep dependencies updated with `go get -u`
- Use `go mod tidy` to remove unused dependencies
- Test thoroughly after vulnerability fixes
- Monitor for new vulnerabilities with automated tools