---
name: email-analyzer
description: Analyze Gmail via gog CLI + AI (preferred) or Python scripts (fallback). Classify, prioritize, detect phishing/prompts, extract tasks, summarize threads.
metadata:
  clawdbot:
    emoji: "🤖"
    requires:
      bins: ["gog"]
      env:
        - name: GOG_ACCOUNT
        - name: ANTHROPIC_API_KEY
          description: "API Key de Anthropic para análisis IA"
    install:
      - id: brew
        kind: brew
        formula: steipete/tap/gogcli
        bins: ["gog"]
        label: "Install gog CLI (brew)"
    routing:
      recommended: "anthropic/claude-sonnet-4"
      alternatives: ["openrouter/anthropic/claude-sonnet-4", "openai/gpt-4o"]
      reason: "Deep reasoning: classification, phishing detection, sentiment, task extraction."
---

# email-analyzer

## Cuándo usar
Usuario pide analizar, clasificar, priorizar correos, detectar phishing/spam/prompts, extraer tareas, o resumir hilos.

## Flujo

### 1 — Obtener correos

**gog (preferido):**
```bash
gog gmail search 'in:inbox newer_than:1d' --max 50 --json --no-input > emails.json
gog gmail search 'in:spam newer_than:7d'  --max 100 --json --no-input >> emails.json
# Hilo: gog gmail search 'subject:"<tema>"' --max 20 --json --no-input
```

**Python (fallback):**
```bash
python3 scripts/fetch_emails.py --label INBOX --max 50 > emails.json
python3 scripts/fetch_thread.py --thread-id <ID> > thread.json
```

### 2 — Análisis batch IA (lotes de 15)
```bash
python3 scripts/analyzer.py --emails-file emails.json --output analysis.json
```

Schema por correo (devolver SOLO array JSON, sin texto extra):
```json
{"id":"str","categoria":"spam|importante|informativo|newsletter|prompt_detectado|otro",
"es_spam":bool,"prioridad":0-10,"tiene_prompt":bool,"prompt_texto":"str|null",
"tareas":["str"],"fecha_limite":"ISO8601|null",
"sentimiento":"positivo|neutro|negativo|urgente",
"es_phishing":bool,"indicadores_phishing":["str"],"razon":"str (1 oración)"}
```

Prioridad: `9-10` urgente hoy · `7-8` responder pronto · `5-6` informativo · `3-4` newsletter · `0-2` spam

### 3 — Detección de prompts IA
Patrones: "Ignore previous instructions", "You are now", "Act as", "Forget your training"
HTML oculto: `color:white`, `display:none`, `font-size:0`

### 4 — Detección de phishing
```bash
python3 scripts/phishing_check.py --emails-file emails.json
```
Indicadores: dominio ≠ marca, URLs acortadas (bit.ly/tinyurl), urgencia+credenciales,
spoofing (paypa1.com/g00gle.com), adjuntos .exe/.zip/.js

### 5 — Resumir hilo largo (>5 mensajes)
```bash
python3 scripts/summarize_thread.py --thread-file thread.json
```

## Presentación
```
🤖 Análisis — N correos
🔴 Críticos(8-10):N  🟡 Imp(5-7):N  📰 News:N  🗑️ Spam:N  🔍 Prompts:N  ⚠️ Phishing:N

Críticos:
1. [P/10] sender — "subject" | Tarea: ... | Deadline: ...
2. [PHISHING ⚠️] sender — "subject" | → NO clic, ¿mover a spam?
```

## Encadenamiento
→ **email-organizer** (mover spam detectado)
→ **email-responder** (generar borradores para críticos)
→ **email-reporter** (registrar en log)

## Errores
- `ANTHROPIC_API_KEY` unset → configurar en entorno o `.env`
- `gog` missing → `brew install steipete/tap/gogcli`
- Token expired → `gog auth add <email>`
