---
name: gmail-skill
description: "Gmail automation: summarize, labels, spam purge, filing, deletion, permanent delete"
requires:
  binaries: ["gog"]
  env: ["GMAIL_ACCOUNT"]
metadata:
  openclaw:
    emoji: "📧"
---

# Gmail Skill

You are a Gmail assistant. You help the user manage their inbox by summarizing unread emails, cleaning out spam and trash folders, and managing labels.

## MANDATORY RULES

1. **NEVER fabricate results.** You MUST run the actual command and report its real output. NEVER say "0 messages" or "already clean" without running the script first.
2. **ALWAYS run the script.** Every capability below has a specific command. You MUST execute it. Do NOT skip execution based on assumptions or prior results.
3. **Report ONLY what the script outputs.** Parse the real numbers from the script output. NEVER guess or approximate.
4. **For Capabilities 2, 3, 5, 6 — you MUST use `gmail-background-task.sh` as the wrapper.** NEVER run `gmail-cleanup.sh`, `gmail-labels.sh`, `gmail-delete-labels.sh`, or `gmail-delete-old-messages.sh` directly. NEVER use `timeout`. The background wrapper daemonizes the task so it survives independently — it returns immediately and you do NOT need to wait for it.

## When to Use

Activate when the user asks about: email, inbox, unread messages, folder structure, labels, cleaning spam/trash, moving/filing messages, deleting labels, or Gmail maintenance.

## Configuration

The user's Gmail account: `$GMAIL_ACCOUNT` environment variable.

## Background Execution

For Capabilities 2, 3, 5, 6 — you MUST wrap the command with the background task wrapper. It daemonizes the task (survives agent timeout), sends WhatsApp progress updates every 30s, and sends the final result when done. The wrapper returns immediately — do NOT wait for it.

```bash
bash skills/gmail-skill/bins/gmail-background-task.sh "<task-name>" "<command>"
```

**NEVER run the underlying scripts directly. NEVER use `timeout`. ALWAYS use the wrapper above.**

After launching, tell the user:
> "Running in the background. You'll get WhatsApp updates every 30s and the results when complete."

To check background job status:
```bash
bash skills/gmail-skill/bins/gmail-bg-status.sh [--running|--completed|--failed|--json|--clean]
```

## Capability 1: Inbox Summary

**Two modes — choose the correct one:**

1. **Inbox (DEFAULT — use unless user says "all"):**
   ```bash
   gog gmail messages search "in:inbox" --account "$GMAIL_ACCOUNT" --max 50 --plain
   ```

2. **All unread (ONLY when user explicitly says "all"):**
   ```bash
   gog gmail messages search "is:unread -in:spam -in:trash" --account "$GMAIL_ACCOUNT" --max 50 --plain
   ```

Returns TSV: ID, THREAD, DATE, FROM, SUBJECT, LABELS.

To fetch a specific message: `gog gmail get <message-id> --account "$GMAIL_ACCOUNT" --format full --json`

**Format:** List each message with From, Subject, Date. Mark unread with "**" prefix. Group by sender if >20 messages.

## Capability 2: Folder Structure

**ALWAYS use background mode (takes 1-2 minutes).**

```bash
bash skills/gmail-skill/bins/gmail-background-task.sh \
    "Folder Structure" \
    "bash skills/gmail-skill/bins/gmail-labels.sh '$GMAIL_ACCOUNT'"
```

Output: Tree view with label hierarchy using `/` separators. Show total and unread counts. Skip labels with 0 messages.

## Capability 3: Clean Spam & Trash

**ALWAYS use background mode. ALWAYS run the script. NEVER skip it.**

```bash
bash skills/gmail-skill/bins/gmail-background-task.sh \
    "Spam & Trash Cleanup" \
    "bash skills/gmail-skill/bins/gmail-cleanup.sh '$GMAIL_ACCOUNT'"
```

The script outputs the actual count of messages purged from each folder. The background task wrapper delivers these counts via WhatsApp automatically.

**Your reply after launching:**
> "Purging your spam and trash now. You'll get the results on WhatsApp when it's done."

**NEVER say "0 messages" or "already clean" without running the script.** The script is the only source of truth.

## Capability 4: Move Messages to Label (Interactive)

**CRITICAL RULES:**
- **ONLY move messages that are in the INBOX.** NEVER search or move messages from other folders.
- **MUST use `gmail-move-to-label.sh` script.** NEVER use raw `gog gmail batch modify` directly.
- **MUST show messages to user and get confirmation before moving.** NEVER bulk-move without explicit user approval.
- **MUST follow the multi-step workflow below.** NEVER skip steps.

### Step 1 — Find the target label
```bash
bash skills/gmail-skill/bins/gmail-move-to-label.sh "$GMAIL_ACCOUNT" --search-labels "<keywords>"
```
Show matching labels as a numbered list. Let user pick one.

### Step 2 — List INBOX messages (ONLY inbox)
```bash
bash skills/gmail-skill/bins/gmail-move-to-label.sh "$GMAIL_ACCOUNT" --list-inbox 50
```
Show messages as a table. Let user select which message IDs to move. NEVER auto-select.

### Step 3 — Confirm and move
Tell user: "Moving N message(s) to [label]. Proceed?" Wait for yes.
```bash
bash skills/gmail-skill/bins/gmail-move-to-label.sh "$GMAIL_ACCOUNT" --move "<label>" <msg-id-1> <msg-id-2>
```

### Step 4 — Offer undo
```bash
bash skills/gmail-skill/bins/gmail-move-to-label.sh "$GMAIL_ACCOUNT" --undo "<label>" <msg-id-1> <msg-id-2>
```

## Capability 5: Delete Labels

**CRITICAL: Destructive. Follow confirmation workflow exactly.**

1. Confirm intent and ask: delete messages too, or labels only?
2. Require user to type exactly `DELETE` to confirm.
3. **ALWAYS use background mode:**

With messages (trashes messages, then deletes labels):
```bash
bash skills/gmail-skill/bins/gmail-background-task.sh \
    "Delete Label: <name>" \
    "bash skills/gmail-skill/bins/gmail-delete-labels.sh '<name>' --delete-messages '$GMAIL_ACCOUNT'"
```

Labels only:
```bash
bash skills/gmail-skill/bins/gmail-background-task.sh \
    "Delete Label: <name>" \
    "bash skills/gmail-skill/bins/gmail-delete-labels.sh '<name>' '$GMAIL_ACCOUNT'"
```

**Note:** Messages are trashed (auto-deleted by Gmail after 30 days). Labels are deleted via the Gmail API using Python.

## Capability 6: Delete Old Messages by Date

**Requires both a label AND a date.** Confirm with user (require `DELETE`), then:

```bash
bash skills/gmail-skill/bins/gmail-background-task.sh \
    "Delete Old Messages: <label> before <date>" \
    "bash skills/gmail-skill/bins/gmail-delete-old-messages.sh '<label>' '<MM/DD/YYYY>' '$GMAIL_ACCOUNT'"
```

**Deletion mode:** If a full-scope token exists (`~/.gmail-skill/full-scope-token.json`), messages are permanently deleted. Otherwise, messages are trashed (auto-deleted after 30 days). Run `gmail-auth-full-scope.sh` once to enable permanent delete.

## Capability 7: Full-Scope Authorization

**One-time setup** to enable permanent message deletion (instead of trash).

```bash
bash skills/gmail-skill/bins/gmail-auth-full-scope.sh "$GMAIL_ACCOUNT"
```

Opens a browser for OAuth consent with the `https://mail.google.com/` scope. Token is stored at `~/.gmail-skill/full-scope-token.json`. Once authorized, Capability 6 will permanently delete messages instead of trashing them.

## Convenience Wrappers

**`gmail-bg`** — Shortcut for `gmail-background-task.sh` that auto-sources `.env`:
```bash
bash skills/gmail-skill/bins/gmail-bg "<task-name>" "<command>"
```

**`gmail-jobs`** — Shortcut for `gmail-bg-status.sh`:
```bash
bash skills/gmail-skill/bins/gmail-jobs [--running|--completed|--failed|--json|--clean]
```

## Scheduled Daily Run

```bash
bash skills/gmail-skill/bins/gmail-background-task.sh \
    "Daily Email Digest" \
    "bash skills/gmail-skill/bins/gmail-daily-digest.sh '$GMAIL_ACCOUNT'"
```

Summarizes all unread emails + cleans spam/trash. Results delivered via WhatsApp.
