---
name: gm3-alertworthy-feed
description: Read-only access to the GM3 Alertworthy feed, providing real-time token market data for analysis agents.
---

# GM3 Alertworthy Feed

--

## Overview
This skill provides read-only access to the GM3 Alertworthy feed.

It returns the current snapshot of alertworthy tokens, including valuation, flow, buyer distribution, and market structure signals. The skill is designed to be used by analysis agents that apply their own filtering and decision logic on top of the raw GM3 data.

This skill does not perform filtering, ranking, or trading actions.

---

## Endpoint
**GET**  
https://api.gm3.fun/functions/v1/gm3-api/v1/paid/alertworthy

---

## Authentication
This skill requires a GM3 Developer API key.

Requests must include the following header:

Authorization: Bearer gm3_key_...


The API key should be stored as a secret and never exposed in client-side code.

---

## Headers
Accept: application/json


---

## Inputs
This endpoint does not accept input parameters.

---

## Output
The response is a JSON object containing a `data` array of alertworthy token snapshots.

Each item may include fields such as:
- mint
- rank
- fdv_usd (current FDV)
- fdv_at_alert (FDV at first alert)
- net_sol_inflow
- buy_ratio
- buy_count / sell_count
- unique_buyers
- capital_efficiency
- market structure flags
- timestamps

The exact fields returned are subject to change as the GM3 platform evolves.

---

## Errors
- **401 Unauthorized** – Invalid or revoked API key, or entitlement expired
- **429 Too Many Requests** – Rate limited
- **500 / 503** – Temporary server error

---

## Notes
- This skill is intended for analysis-only use.
- Strategy logic, filtering, and decision-making should be implemented at the agent level.
- No trading or execution functionality is provided by this skill.
