# Structure Template

Template for `.planning/codebase/STRUCTURE.md` - captures physical file organization.

**Purpose:** Document where things physically live in the codebase. Answers "where do I put X?"

---

## File Template

```markdown
# Codebase Structure

**Analysis Date:** [YYYY-MM-DD]

## Directory Layout

[ASCII tree of top-level directories with purpose]

```
[project-root]/
├── [dir]/          # [Purpose]
├── [dir]/          # [Purpose]
├── [dir]/          # [Purpose]
└── [file]          # [Purpose]
```

## Directory Purposes

**[Directory Name]:**
- Purpose: [What lives here]
- Contains: [Types of files: e.g., "*.ts source files", "component directories"]
- Key files: [Important files in this directory]
- Subdirectories: [If nested, describe structure]

**[Directory Name]:**
- Purpose: [What lives here]
- Contains: [Types of files]
- Key files: [Important files]
- Subdirectories: [Structure]

## Key File Locations

**Entry Points:**
- [Path]: [Purpose: e.g., "CLI entry point"]
- [Path]: [Purpose: e.g., "Server startup"]

**Configuration:**
- [Path]: [Purpose: e.g., "TypeScript config"]
- [Path]: [Purpose: e.g., "Build configuration"]
- [Path]: [Purpose: e.g., "Environment variables"]

**Core Logic:**
- [Path]: [Purpose: e.g., "Business services"]
- [Path]: [Purpose: e.g., "Database models"]
- [Path]: [Purpose: e.g., "API routes"]

**Testing:**
- [Path]: [Purpose: e.g., "Unit tests"]
- [Path]: [Purpose: e.g., "Test fixtures"]

**Documentation:**
- [Path]: [Purpose: e.g., "User-facing docs"]
- [Path]: [Purpose: e.g., "Developer guide"]

## Naming Conventions

**Files:**
- [Pattern]: [Example: e.g., "kebab-case.ts for modules"]
- [Pattern]: [Example: e.g., "PascalCase.tsx for React components"]
- [Pattern]: [Example: e.g., "*.test.ts for test files"]

**Directories:**
- [Pattern]: [Example: e.g., "kebab-case for feature directories"]
- [Pattern]: [Example: e.g., "plural names for collections"]

**Special Patterns:**
- [Pattern]: [Example: e.g., "index.ts for directory exports"]
- [Pattern]: [Example: e.g., "__tests__ for test directories"]

## Where to Add New Code

**New Feature:**
- Primary code: [Directory path]
- Tests: [Directory path]
- Config if needed: [Directory path]

**New Component/Module:**
- Implementation: [Directory path]
- Types: [Directory path]
- Tests: [Directory path]

**New Route/Command:**
- Definition: [Directory path]
- Handler: [Directory path]
- Tests: [Directory path]

**Utilities:**
- Shared helpers: [Directory path]
- Type definitions: [Directory path]

## Special Directories

[Any directories with special meaning or generation]

**[Directory]:**
- Purpose: [e.g., "Generated code", "Build output"]
- Source: [e.g., "Auto-generated by X", "Build artifacts"]
- Committed: [Yes/No - in .gitignore?]

---

*Structure analysis: [date]*
*Update when directory structure changes*
```

<good_examples>
```markdown
# Codebase Structure

**Analysis Date:** 2025-01-20

## Directory Layout

```
get-shit-done/
├── bin/                # Executable entry points
├── commands/           # Slash command definitions
│   └── gsd/           # GSD-specific commands
├── get-shit-done/     # Skill resources
│   ├── references/    # Principle documents
│   ├── templates/     # File templates
│   └── workflows/     # Multi-step procedures
├── src/               # Source code (if applicable)
├── tests/             # Test files
├── package.json       # Project manifest
└── README.md          # User documentation
```

## Directory Purposes

**bin/**
- Purpose: CLI entry points
- Contains: install.js (installer script)
- Key files: install.js - handles npx installation
- Subdirectories: None

**commands/gsd/**
- Purpose: Slash command definitions for Claude Code
- Contains: *.md files (one per command)
- Key files: new-project.md, plan-phase.md, execute-plan.md
- Subdirectories: None (flat structure)

**get-shit-done/references/**
- Purpose: Core philosophy and guidance documents
- Contains: principles.md, questioning.md, plan-format.md
- Key files: principles.md - system philosophy
- Subdirectories: None

**get-shit-done/templates/**
- Purpose: Document templates for .planning/ files
- Contains: Template definitions with frontmatter
- Key files: project.md, roadmap.md, plan.md, summary.md
- Subdirectories: codebase/ (new - for stack/architecture/structure templates)

**get-shit-done/workflows/**
- Purpose: Reusable multi-step procedures
- Contains: Workflow definitions called by commands
- Key files: execute-plan.md, research-phase.md
- Subdirectories: None

## Key File Locations

**Entry Points:**
- `bin/install.js` - Installation script (npx entry)

**Configuration:**
- `package.json` - Project metadata, dependencies, bin entry
- `.gitignore` - Excluded files

**Core Logic:**
- `bin/install.js` - All installation logic (file copying, path replacement)

**Testing:**
- `tests/` - Test files (if present)

**Documentation:**
- `README.md` - User-facing installation and usage guide
- `CLAUDE.md` - Instructions for Claude Code when working in this repo

## Naming Conventions

**Files:**
- kebab-case.md: Markdown documents
- kebab-case.js: JavaScript source files
- UPPERCASE.md: Important project files (README, CLAUDE, CHANGELOG)

**Directories:**
- kebab-case: All directories
- Plural for collections: templates/, commands/, workflows/

**Special Patterns:**
- {command-name}.md: Slash command definition
- *-template.md: Could be used but templates/ directory preferred

## Where to Add New Code

**New Slash Command:**
- Primary code: `commands/gsd/{command-name}.md`
- Tests: `tests/commands/{command-name}.test.js` (if testing implemented)
- Documentation: Update `README.md` with new command

**New Template:**
- Implementation: `get-shit-done/templates/{name}.md`
- Documentation: Template is self-documenting (includes guidelines)

**New Workflow:**
- Implementation: `get-shit-done/workflows/{name}.md`
- Usage: Reference from command with `@/usr/lib/node_modules/clawdbot/skills/gsd/workflows/{name}.md`

**New Reference Document:**
- Implementation: `get-shit-done/references/{name}.md`
- Usage: Reference from commands/workflows as needed

**Utilities:**
- No utilities yet (`install.js` is monolithic)
- If extracted: `src/utils/`

## Special Directories

**get-shit-done/**
- Purpose: Resources installed to /usr/lib/node_modules/clawdbot/
- Source: Copied by bin/install.js during installation
- Committed: Yes (source of truth)

**commands/**
- Purpose: Slash commands installed to /usr/lib/node_modules/clawdbot/commands/
- Source: Copied by bin/install.js during installation
- Committed: Yes (source of truth)

---

*Structure analysis: 2025-01-20*
*Update when directory structure changes*
```
</good_examples>

<guidelines>
**What belongs in STRUCTURE.md:**
- Directory layout (ASCII tree)
- Purpose of each directory
- Key file locations (entry points, configs, core logic)
- Naming conventions
- Where to add new code (by type)
- Special/generated directories

**What does NOT belong here:**
- Conceptual architecture (that's ARCHITECTURE.md)
- Technology stack (that's STACK.md)
- Code implementation details (defer to code reading)
- Every single file (focus on directories and key files)

**When filling this template:**
- Use `tree -L 2` or similar to visualize structure
- Identify top-level directories and their purposes
- Note naming patterns by observing existing files
- Locate entry points, configs, and main logic areas
- Keep directory tree concise (max 2-3 levels)

**ASCII tree format:**
```
root/
├── dir1/           # Purpose
│   ├── subdir/    # Purpose
│   └── file.ts    # Purpose
├── dir2/          # Purpose
└── file.ts        # Purpose
```

**Useful for phase planning when:**
- Adding new features (where should files go?)
- Understanding project organization
- Finding where specific logic lives
- Following existing conventions
</guidelines>
