---
name: gitlab-private
description: 通过 OAuth 授权访问私有 GitLab 仓库，支持多用户授权，加密存储
tags: [gitlab, oauth, api, private, code]
---

# GitLab Private

通过 OAuth 授权访问私有 GitLab 仓库，支持多用户授权，敏感信息加密存储。

## 首次设置流程

### 步骤 1：初始化（生成加密密钥）

```bash
cd ~/clawd/skills/gitlab-private
node index.js setup
```

### 步骤 2：配置 OAuth 应用

```bash
node index.js config <你的Application ID> <你的Secret> <GitLab地址>
```

示例：
```bash
node index.js config your_app_id your_secret http://gitlab.你的公司.com
```

### 步骤 3：验证配置

```bash
node index.js auth-url
```

显示授权链接即配置成功。

## 群里使用流程

### 1. 用户发 GitLab 仓库链接

机器人回复授权链接

### 2. 用户发授权链接

用户把完整链接发给机器人，机器人自动处理授权

### 3. 后续使用

同一个人后续发仓库链接，直接读取

## 命令行使用

```bash
# 初始化（首次使用）
node index.js setup

# 配置 OAuth 应用
node index.js config <AppID> <Secret> [GitLab URL]

# 生成授权链接
node index.js auth-url

# 处理授权
node index.js handle <用户ID> <授权链接>

# 使用用户 token 执行命令
node index.js use <用户ID> list use <用户ID
node index.js> project <关键词>
node index.js use <用户ID> merge <项目ID> [分支]

# 列出已授权用户
node index.js users
```

## 安全特性

- **加密存储**：token 和 OAuth 配置使用 AES-256-CBC 加密
- **密钥本地保存**：加密密钥保存在 config/key.txt
- **按用户隔离**：不同用户 token 分开存储
- **敏感信息本地**：不会上传到 clawhub

## 配置文件

| 文件 | 说明 |
|------|------|
| `config/key.txt` | 加密密钥 |
| `config/oauth.json` | 加密的 OAuth 配置 |
| `config/users.enc` | 加密的用户 token |
| `~/.gitlab-token` | 全局 GitLab Token（可选） |

**Token 优先级**：
1. 环境变量 `GITLAB_TOKEN`
2. 用户配置文件
3. 全局 token 文件 `~/.gitlab-token`

这些文件不会上传到 clawhub。
