---
name: gitlab-manager
description: Manage GitLab repositories, merge requests, and issues via API. Use for tasks like creating repos, reviewing code in MRs, or tracking issues.
---

# GitLab Manager

This skill allows interaction with GitLab.com via the API.

## Prerequisites

- **GITLAB_TOKEN**: A Personal Access Token with `api` scope must be set in the environment.

## Usage

Use the provided Node.js script to interact with GitLab.

### Script Location
`scripts/gitlab_api.js`

### Commands

#### 1. Create Repository
Create a new project in GitLab.
```bash
./scripts/gitlab_api.js create_repo "<name>" "<description>" "<visibility>"
# Visibility: private (default), public, internal
```

#### 2. List Merge Requests
List MRs for a specific project.
```bash
./scripts/gitlab_api.js list_mrs "<project_path>" "[state]"
# Project path: e.g., "jorgermp/my-repo" (will be URL encoded automatically)
# State: opened (default), closed, merged, all
```

#### 3. Comment on Merge Request
Add a comment (note) to a specific MR. Useful for code review.
```bash
./scripts/gitlab_api.js comment_mr "<project_path>" <mr_iid> "<comment_body>"
```

#### 4. Create Issue
Open a new issue.
```bash
./scripts/gitlab_api.js create_issue "<project_path>" "<title>" "<description>"
```

## Examples

**Create a private repo:**
```bash
GITLAB_TOKEN=... ./scripts/gitlab_api.js create_repo "new-tool" "A cool new tool" "private"
```

**Review an MR:**
```bash
# First list to find ID
GITLAB_TOKEN=... ./scripts/gitlab_api.js list_mrs "jorgermp/my-tool" "opened"
# Then comment
GITLAB_TOKEN=... ./scripts/gitlab_api.js comment_mr "jorgermp/my-tool" 1 "Great work, but check indentation."
```
