---
name: glab-auth
description: Manage GitLab CLI authentication including login/logout, check auth status, switch accounts, and configure Docker registry access. Use when setting up glab for first time, troubleshooting auth issues, switching GitLab instances/accounts, or configuring Docker to pull from GitLab registry. Triggers on auth, login, logout, authentication, credentials, token, Docker registry.
---

# glab auth

Manage GitLab CLI authentication.

## Quick start

```bash
# Interactive login
glab auth login

# Check current auth status
glab auth status

# Login to different instance
glab auth login --hostname gitlab.company.com

# Logout
glab auth logout
```

## Workflows

### First-time setup

1. Run `glab auth login`
2. Choose authentication method (token or browser)
3. Follow prompts for your GitLab instance
4. Verify with `glab auth status`

### Switching accounts/instances

1. **Logout from current:**
   ```bash
   glab auth logout
   ```

2. **Login to new instance:**
   ```bash
   glab auth login --hostname gitlab.company.com
   ```

3. **Verify:**
   ```bash
   glab auth status
   ```

### Docker registry access

1. **Configure Docker helper:**
   ```bash
   glab auth configure-docker
   ```

2. **Verify Docker can authenticate:**
   ```bash
   docker login registry.gitlab.com
   ```

3. **Pull private images:**
   ```bash
   docker pull registry.gitlab.com/group/project/image:tag
   ```

## Troubleshooting

**"401 Unauthorized" errors:**
- Check status: `glab auth status`
- Verify token hasn't expired (check GitLab settings)
- Re-authenticate: `glab auth login`

**Multiple instances:**
- Use `--hostname` flag to specify instance
- Each instance maintains separate auth

**Docker authentication fails:**
- Re-run: `glab auth configure-docker`
- Check Docker config: `cat ~/.docker/config.json`
- Verify helper is set: `"credHelpers": { "registry.gitlab.com": "glab-cli" }`

## Subcommands

See [references/commands.md](references/commands.md) for detailed flag documentation:
- `login` - Authenticate with GitLab instance
- `logout` - Log out of GitLab instance
- `status` - View authentication status
- `configure-docker` - Configure Docker to use GitLab registry
- `docker-helper` - Docker credential helper
- `dpop-gen` - Generate DPoP token

## Related Skills

**Initial setup:**
- After authentication, see `glab-config` to set CLI defaults
- See `glab-ssh-key` for SSH key management
- See `glab-gpg-key` for commit signing setup

**Repository operations:**
- See `glab-repo` for cloning repositories
- Authentication required before first clone/push

