# MCP Prerequisites Setup

A skill for verifying and configuring the required MCP (Model Context Protocol) servers for the Product Guide Writer workflow.

## Overview

The Product Guide Writer relies on several MCP servers to provide external integrations. This skill helps verify that required MCPs are configured and guides users through setup if needed.

## When to Use

Use this skill when:
- Starting the Product Guide Writer for the first time
- Encountering MCP-related errors during documentation workflow
- Setting up a new development environment
- Troubleshooting Confluence/GitHub integration issues

---

## Required MCP Servers

| MCP Server | Purpose | Required | Features Used |
|------------|---------|----------|---------------|
| **user-atlassian** | Confluence search/publish, Jira integration | **Yes** | searchConfluenceUsingCql, createConfluencePage, getConfluenceSpaces |
| **user-github** | Repository search, code exploration | **Yes** | search_repositories, search_code, get_file_contents |
| **user-Figma** | Design mockup retrieval | Optional | get_file, get_images |
| **user-elasticsearch-mcp** | Log analysis for request flow verification | Optional | search, get |

---

## Step 1: Verify MCP Status

### 1.1: Check Enabled MCP Servers

The agent should verify MCP availability by checking the MCP configuration folder:

```
/Users/{username}/.cursor/projects/{workspace}/mcps/
```

Look for these directories:
- `user-atlassian/` - Atlassian MCP (required)
- `user-github/` - GitHub MCP (required)
- `user-Figma/` - Figma MCP (optional)
- `user-elasticsearch-mcp/` - Elasticsearch MCP (optional)

### 1.2: Test Atlassian MCP Connection

Use the `getAccessibleAtlassianResources` tool to verify Atlassian authentication:

```
Tool: CallMcpTool
Server: user-atlassian
ToolName: getAccessibleAtlassianResources
Arguments: {}
```

**Expected Response:** List of accessible Atlassian Cloud instances including Trading212.

**If Error:** Guide user through authentication (see Step 2).

### 1.3: Verify GT Space Access

Confirm access to the Product Documentation space:

```
Tool: CallMcpTool
Server: user-atlassian
ToolName: getConfluenceSpaces
Arguments:
  cloudId: "trading212.atlassian.net"
  keys: ["GT"]
```

**Expected Response:** Space details for GT (Product Documentation space).

**If Error:** User may need additional Confluence permissions.

---

## Step 2: MCP Configuration Guide

If any required MCP is missing or misconfigured, guide the user:

### 2.1: Atlassian MCP Setup

**If `user-atlassian` is not configured:**

1. **Open Cursor Settings:**
   - Press `Cmd/Ctrl + ,` to open settings
   - Navigate to "MCP Servers" or "Extensions"

2. **Add Atlassian MCP:**
   - Search for "Atlassian" in the MCP marketplace
   - Install the official Atlassian MCP server
   - Or add manually to `mcp.json` (official Atlassian remote MCP):
   ```json
   {
     "atlassian-mcp": {
       "url": "https://mcp.atlassian.com/v1/mcp"
     }
   }
   ```

3. **Authenticate:**
   - When prompted, authorize access to your Atlassian account
   - Grant access to the Trading212 workspace
   - Ensure you have access to the GT Confluence space

4. **Verify Installation:**
   - Restart Cursor
   - Run the verification check in Step 1.2

### 2.2: GitHub MCP Setup

**If `user-github` is not configured:**

1. **Install GitHub MCP:**
   - Usually pre-installed with Cursor
   - If missing, add to `mcp_servers.json`:
   ```json
   {
     "github": {
       "command": "npx",
       "args": ["-y", "@modelcontextprotocol/server-github"],
       "env": {
         "GITHUB_TOKEN": "${GITHUB_TOKEN}"
       }
     }
   }
   ```

2. **Configure GitHub Token:**
   - Create a Personal Access Token at github.com/settings/tokens
   - Grant `repo` and `read:org` scopes
   - Set as environment variable: `export GITHUB_TOKEN=your_token`

3. **Verify Access:**
   - Test with a simple repository search
   - Ensure access to Trading212 organization

### 2.3: Optional MCPs

**Figma MCP (for UI documentation):**
- Install: `@anthropic/mcp-server-figma`
- Requires Figma access token
- Useful for documenting user-facing features

**Elasticsearch MCP (for log verification):**
- Install: `@anthropic/mcp-server-elasticsearch`
- Requires Elasticsearch cluster access
- Used in Phase 4 verification

---

## Step 3: Configuration Validation

After setup, run a full validation:

### 3.1: Validation Checklist

```markdown
## MCP Configuration Status

### Required MCPs
- [ ] user-atlassian: Connected to trading212.atlassian.net
- [ ] user-github: Connected to Trading212 organization

### Optional MCPs
- [ ] user-Figma: {Connected / Not configured}
- [ ] user-elasticsearch-mcp: {Connected / Not configured}

### Confluence Access
- [ ] GT Space accessible: trading212.atlassian.net/wiki/spaces/gt
- [ ] Can search pages: searchConfluenceUsingCql works
- [ ] Can create pages: createConfluencePage permission confirmed

### GitHub Access
- [ ] Can search repositories: search_repositories works
- [ ] Can search code: search_code works
- [ ] Trading212 org accessible
```

### 3.2: Test Search

Perform a test search to confirm full functionality:

```
Tool: CallMcpTool
Server: user-atlassian
ToolName: searchConfluenceUsingCql
Arguments:
  cloudId: "trading212.atlassian.net"
  cql: "space = GT AND type = page"
  limit: 5
```

If this returns results, Atlassian MCP is fully configured.

---

## Troubleshooting

| Issue | Cause | Solution |
|-------|-------|----------|
| "MCP server not found" | MCP not installed | Follow Step 2 setup guide |
| "Authentication failed" | Token expired/invalid | Re-authenticate in Cursor settings |
| "Permission denied" for GT space | Confluence permissions | Request access from Confluence admin |
| "Rate limited" | Too many API calls | Wait and retry, or use caching |
| "Cloud ID not found" | Wrong Atlassian instance | Use `getAccessibleAtlassianResources` to find correct ID |

---

## Quick Reference

### Atlassian Cloud ID
```
trading212.atlassian.net
```

### GT Space Details
```
Space Key: GT
Space Name: Product Documentation
URL: https://trading212.atlassian.net/wiki/spaces/gt
```

### Useful CQL Queries

**Find all product guides:**
```
space = GT AND type = page AND title ~ "Product Guide"
```

**Find guides for specific OTT:**
```
space = GT AND type = page AND text ~ "{ott-name}"
```

**Find recently updated pages:**
```
space = GT AND type = page AND lastmodified >= now("-30d")
```

---

## Integration with Product Guide Writer

Once MCPs are configured, the Product Guide Writer will:

1. **Phase 1:** Use Atlassian MCP to search for existing documentation
2. **Phase 4:** Use Atlassian MCP to populate Related Pages and optionally publish
3. **Throughout:** Use GitHub MCP for repository discovery and code search

See [product-guide-writer/SKILL.md](../product-guide-writer/SKILL.md) for the full workflow.
