---
name: gitflow
description: Automatically monitor CI/CD pipeline status of new push across GitHub and GitLab in one place. Auto DevOps this is the way 🦞!
---

# GitFlow — OpenClaw Skill

## Overview
**GitFlow** is an OpenClaw skill that automates code pushes and provides real-time CI/CD pipeline status monitoring for GitHub and GitLab repositories. It streamlines developer workflows by reducing context switching between repositories and pipeline dashboards.

The skill can automatically push changes and report pipeline results, enabling faster feedback and smoother deployments.

## Features
GitFlow can:

- Push local commits automatically
- Trigger remote CI/CD pipelines
- Fetch pipeline status and results
- Report build success or failure
- Display pipeline URLs and logs
- Monitor multiple repositories


## Typical Workflow
1. Developer commits changes locally.
2. GitFlow pushes changes automatically or on command.
3. CI/CD pipeline runs remotely.
4. Skill reports pipeline status.
5. Developer receives build/deploy feedback instantly.


## GitHub CLI Commands

Use the `gh` CLI tool to fetch workflow status after pushing:

### Check Workflow Run Status
```bash
gh run list
```
Lists recent workflow runs for the repository.

### View Latest Run for Current Branch
```bash
gh run list --branch $(git branch --show-current) --limit 1
```
Shows the most recent workflow run for the current branch.

### View Run Details
```bash
gh run view <run-id>
```
Displays detailed information about a specific workflow run.

### Watch Run in Real-Time
```bash
gh run watch
```
Watches the most recent run until completion, streaming status updates.

### View Run Logs
```bash
gh run view <run-id> --log
```
Displays the full logs for a workflow run.

### View Failed Job Logs
```bash
gh run view <run-id> --log-failed
```
Shows only the logs from failed jobs.

### Rerun Failed Jobs
```bash
gh run rerun <run-id> --failed
```
Reruns only the failed jobs from a workflow run.

---

## GitLab CLI Commands

Use the `glab` CLI tool to fetch pipeline status after pushing:

### Check Pipeline Status
```bash
glab ci status
```
Shows the status of the most recent pipeline on the current branch.

### View Pipeline Details
```bash
glab ci view
```
Opens an interactive view of the current pipeline with job details.

### List Recent Pipelines
```bash
glab ci list
```
Lists recent pipelines for the repository.

### View Specific Pipeline
```bash
glab ci view <pipeline-id>
```
View details of a specific pipeline by ID.

### Watch Pipeline in Real-Time
```bash
glab ci status --live
```
Continuously monitors the pipeline status until completion.

### Get Pipeline Job Logs
```bash
glab ci trace <job-id>
```
Streams the logs of a specific job.

---

## Post-Push Hook Example

Git doesn't have a native post-push hook, but you can create a git alias to automatically monitor pipeline status after pushing.

Add this to your `~/.gitconfig`:

```ini
[alias]
    pushflow = "!f() { \
        git push \"${1:-origin}\" \"${2:-$(git branch --show-current)}\"; \
        url=$(git remote get-url \"${1:-origin}\"); \
        if echo \"$url\" | grep -q 'github.com'; then \
            sleep 3 && gh run watch; \
        elif echo \"$url\" | grep -q 'gitlab'; then \
            sleep 3 && glab ci status --live; \
        fi; \
    }; f"
```

### Usage

```bash
git pushflow
git pushflow origin main
```

---

