# Gitai: Automated Conventional Commits

**Transform your git history with AI. From chaotic logs to semantic perfection.**

[![Version](https://img.shields.io/badge/version-1.0.0-blue.svg)](https://github.com/leandrosilvaferreira/gitai-skill)
[![License](https://img.shields.io/badge/license-MIT-green.svg)](LICENSE)
[![Node.js](https://img.shields.io/badge/node-%3E%3D18-brightgreen.svg)](https://nodejs.org/)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-orange.svg)](https://github.com/leandrosilvaferreira/gitai-skill/pulls)
[![Ko-fi](https://img.shields.io/badge/Ko--fi-Support%20this%20project-FF5E5B?logo=ko-fi&logoColor=white)](https://ko-fi.com/leandrozuck)

---

## The Problem

Writing meaningful commit messages is often the last thing on a developer's mind. We're focused on the code, not the log. This leads to repositories full of `fix`, `wip`, or `update` messages that make history audits a nightmare.

**Common issues:**
- **Inconsistent History**: "Added feature" vs "feat: add new feature"
- **Mental Fatigue**: Context switching to write summaries breaks flow
- **Lost Context**: "Fixed bug" (Which bug? How? Why?)
- **Time Wasted**: Minutes lost per day thinking of message formatting

## The Solution

Gitai acts as your intelligent pair programmer that handles the bureaucracy of version control. It analyzes your staged changes and generates precise, descriptive, Conventional Commits-compliant messages instantly.

| Feature | Before (Manual) | After (Gitai) |
|---------|-----------------|---------------|
| **Consistency** | Varies by mood/coffee | 100% Conventional Commits |
| **Detail Level** | Often vague | Semantic & Descriptive |
| **Effort** | High friction | One command (`gitai`) |
| **Accuracy** | Human error prone | AI-analyzed diffs |

**Result: A professional, navigable git history with zero extra effort.**

## Efficiency Comparison

| Metric | Manual Commit | Gitai Automation |
|--------|---------------|------------------|
| Time per commit | 30-90 seconds | **3-5 seconds** |
| Cognitive Load | High (Summarizing diffs) | **Zero** (Review only) |
| Standard Compliance | Hit or miss | **Guaranteed** |

## Quick Start

### Installation

**MacOS / Linux:**
```bash
chmod +x scripts/install.sh
./scripts/install.sh
```

**Windows (PowerShell):**
```powershell
.\scripts\install.ps1
```

### Configuration (One Time)

Gitai needs to know your preferred AI provider. Run the setup:

1.  Create `~/.gitai`:
    ```bash
    nano ~/.gitai
    ```
2.  Add your settings:
    ```env
    PROVIDER=openai # or anthropic, groq
    API_KEY=sk-...
    MODEL=gpt-4o
    LANGUAGE=en
    ```

## Features

### 1. Universal Language Support
Gitai understands code, not just syntax. Whether you're writing **Node.js, Python, Java, Go, PHP**, or **Rust**, Gitai analyzes the logic changes to generate accurate summaries.

### 2. Multi-LLM Support
Choose your brain. Gitai supports:
- **OpenAI** (GPT-4o, GPT-3.5)
- **Anthropic** (Claude 3.5 Sonnet, Haiku)
- **Groq** (Llama 3, Mixtral - strict/fast)

### 3. Workflow Automation
Combine stages, commits, and pushes into single fluid actions.

**Standard Workflow:**
```bash
# Analyze all changes, commit, and push
gitai . "" --push
```

**Scoped Workflow:**
```bash
# Analyze only frontend folder
gitai ./frontend "ui refresh"
```

## Usage

### Basic Usage
```bash
gitai [path] [base-message] [options]
```

### Examples
| Goal | Command |
|------|---------|
| **Auto-commit everything** | `gitai` |
| **Commit specific path** | `gitai src/components` |
| **Add context hint** | `gitai . "fix login bug"` |
| **Commit & Push** | `gitai . "" --push` |

## Troubleshooting

### Wizard Hangs?
If `gitai` hangs waiting for input, ensure your `~/.gitai` config file exists and is valid. Background agents cannot interact with the setup wizard.

### "Command not found"?
Ensure the installation script completed successfully and added gitai to your PATH.

## Support

- **Issues**: [GitHub Issues](https://github.com/leandrosilvaferreira/gitai-skill/issues)

**If Gitai saves you time, consider supporting development:**

[![Ko-fi](https://ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/leandrozuck)

## License

MIT. See [LICENSE](LICENSE) for details.

---

**Built with ❤️ by [Leandro Zuck](https://github.com/leandrosilvaferreira)**
