---
name: git-summary
description: Get a quick summary of the current Git repository including status, recent commits, branches, and contributors.
user-invocable: true
metadata: {"openclaw": {"emoji": "📊", "requires": {"bins": ["git"]}, "os": ["darwin", "linux", "win32"]}}
---

# Git Summary Skill

This skill provides a comprehensive overview of the current Git repository state.

## Usage

When the user asks for a git summary, repository overview, or wants to understand the current state of a git project, use the terminal to run the following commands and present the results in a clear, organized format.

## Instructions

1. **Repository Status**: Run `git status --short --branch` to get the current branch and working directory status.

2. **Recent Commits**: Run `git log --oneline -10 --decorate` to show the last 10 commits with branch/tag decorations.

3. **Branch Overview**: Run `git branch -a --list` to list all local and remote branches.

4. **Remote Info**: Run `git remote -v` to show configured remotes.

5. **Uncommitted Changes Summary**: 
   - Run `git diff --stat` for unstaged changes
   - Run `git diff --cached --stat` for staged changes

6. **Contributors** (optional, for larger context): Run `git shortlog -sn --all | head -10` to show top 10 contributors.

## Output Format

Present the gathered information in a structured format:

```
## 📊 Git Repository Summary

### Current Branch & Status
- Branch: `<branch_name>`
- Status: <clean/dirty with X modified, Y staged, Z untracked>

### Recent Commits (Last 10)
<formatted commit list>

### Branches
- Local: <count> branches
- Remote: <count> branches
<list notable branches>

### Remotes
<list remotes with URLs>

### Uncommitted Changes
<summary of staged and unstaged changes>
```

## Notes

- If not in a git repository, inform the user and suggest initializing one with `git init`.
- For large repositories, the contributor list may take a moment - warn the user if this is expected.
- Always respect that some information may be sensitive - don't expose full URLs if they contain tokens.
