#!/bin/bash
# Get current public IP and location
# Usage: ./get_ip.sh

echo "Fetching IP information..."

# Try myip.ipip.net first (Chinese-friendly, shows geolocation)
RESULT=$(curl -s --max-time 2 myip.ipip.net 2>/dev/null)

if [ $? -eq 0 ] && [ -n "$RESULT" ]; then
    echo "$RESULT"
    exit 0
fi

# Fallback to ipify for just the IP
IP=$(curl -s --max-time 2 https://api.ipify.org 2>/dev/null || curl -s --max-time 2 ifconfig.me 2>/dev/null || curl -s --max-time 2 icanhazip.com 2>/dev/null )

if [ $? -eq 0 ] && [ -n "$IP" ]; then
    echo "IP: $IP"
    
    # Try to get geolocation
    GEO=$(curl -s "https://ipinfo.io/$IP/json" 2>/dev/null)
    if [ $? -eq 0 ] && [ -n "$GEO" ]; then
        echo "$GEO" | python3 -c "
import json, sys
data = json.load(sys.stdin)
print(f\"Location: {data.get('city', 'N/A')}, {data.get('region', 'N/A')}, {data.get('country', 'N/A')}\")
print(f\"ISP: {data.get('org', 'N/A')}\")
"
    fi
    exit 0
fi

echo "Error: Could not retrieve IP information. Check your network connection."
exit 1
