---
name: German
description: Write German that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI German is technically correct but sounds off. Too formal. Too Hochdeutsch. Too stiff. Natives write more directly, with particles and casual flow. Match that.

## Formality Default

Default register is too high. Casual German is direct and efficient. Unless explicitly formal: lean casual. "Hi" not "Guten Tag". "Ja" not "Jawohl". "Ok" not "In Ordnung".

## Du vs Sie

Critical distinction:
- Sie: strangers, professional, formal business
- Du: friends, peers, most internet, casual workplaces
- German internet is almost entirely du
- Overusing Sie online = robotic, out of touch

## Modal Particles

These make German sound native:
- "mal": softening ("Schau mal", "Sag mal")
- "doch": contradiction, emphasis ("Das ist doch gut")
- "ja": shared knowledge ("Das weißt du ja")
- "halt": resignation ("Ist halt so")
- "eben": "just the way it is"
- "schon": reassurance ("Wird schon")
- Missing these = textbook German

## Fillers & Flow

Real German has fillers:
- "Also", "naja", "tja"
- "Sozusagen", "quasi", "irgendwie"
- "Ähm", "öhm", "hm"
- "Jedenfalls", "übrigens", "apropos"

## Casual Shortcuts

Spoken patterns in writing:
- "Hast du" → "Haste"
- "Ich habe" → "Ich hab"
- "Wir haben" → "Wir ham"
- "Etwas" → "was"
- "Einmal" → "mal"

## Expressiveness

Don't pick the safe word:
- "Gut" → "Super", "Geil", "Hammer", "Krass"
- "Schlecht" → "Mist", "Scheiße", "Kacke"
- "Sehr" → "Mega", "Ultra", "Voll"
- "Toll" → "Geil", "Hammer", "Der Wahnsinn"

## Common Expressions

Natural expressions:
- "Kein Problem", "Passt", "Geht klar"
- "Keine Ahnung", "Keinen Plan"
- "Echt jetzt?", "Im Ernst?"
- "Läuft", "Alles klar", "Geht so"

## Reactions

React naturally:
- "Krass!", "Heftig!", "Boah!"
- "Echt?", "Wirklich?", "Ernsthaft?"
- "Geil!", "Nice!", "Stark!"
- "Mist", "Verdammt", "Scheiße"
- "Haha", "lol", "xD" in casual text

## Compound Words

German creates compounds. Use them naturally:
- Don't over-explain with phrases when one compound works
- "Geschwindigkeitsbegrenzung" not "Begrenzung der Geschwindigkeit"
- But don't create absurdly long ones unnecessarily

## Regional Awareness

If region known, adapt:
- Austria: "Grüß Gott", "Servus", "leiwand", "ur"
- Switzerland: "Grüezi", "merci", different vocabulary
- Bavaria: "Grüß Gott", "Pfiat di", dialect features
- Don't mix. Stay consistent.

## Punctuation

German punctuation:
- „Anführungszeichen" for quotes (low-high)
- Numbers: 1.000,50 (period thousands, comma decimals)
- Comma before "dass", "weil", "wenn" clauses

## The "Native Test"

Before sending: would a German speaker screenshot this as "AI-generated"? If yes—too formal, missing particles, too stiff. Loosen up.
