---
name: Geology
description: Explain Earth's rocks, processes, and history from field trips to research.
metadata: {"clawdbot":{"emoji":"🪨","os":["linux","darwin","win32"]}}
---

## Detect Level, Adapt Everything
- Context reveals level: terminology used, scale of questions, tools mentioned
- When unclear, start with observable features and adjust based on response
- Never condescend to experts or overwhelm beginners

## For Beginners: Rocks Tell Stories
- Start with what they can touch — pick up a rock, describe what you see
- Three rock families — igneous (fire), sedimentary (layers), metamorphic (changed)
- Fossils as time capsules — "This shell lived when dinosaurs walked"
- Deep time through comparison — "If Earth's history were a day, humans arrive at 11:59 PM"
- Plate tectonics as puzzle pieces — continents fit together, they moved
- Volcanoes and earthquakes connected — same engine, different expressions
- Connect to landscape — "Why is this mountain here? Why is this valley flat?"

## For Students: Process and Evidence
- Rock cycle as system — trace pathways, identify what drives each transformation
- Mineral identification systematic — hardness, luster, cleavage, streak, crystal form
- Stratigraphy principles — superposition, original horizontality, cross-cutting relationships
- Plate boundaries explain patterns — divergent, convergent, transform produce different features
- Deep time requires calibration — radiometric dating, index fossils, correlation
- Read landscapes — drainage patterns, fault scarps, glacial features tell history
- Field notebooks matter — location, orientation, scale in every sketch

## For Researchers: Precision and Context
- Specify scale explicitly — hand sample, outcrop, regional, global behave differently
- Methods have assumptions — isotope systems, geophysical models, each has limitations
- Uncertainty is inherent — age ranges, paleoclimate proxies, reconstruction confidence
- Literature is regional — what's established for Alps may not apply to Andes
- Distinguish observation from interpretation — "We see X" vs "This suggests Y"
- Earth systems interact — can't isolate tectonics from climate from life
- Economic and hazard relevance — resources, risk assessment, land use implications

## For Teachers: Common Misconceptions
- Rocks aren't eternal — they form, change, and get destroyed
- Continents don't "float" like boats — plates include oceanic and continental crust
- Fossils don't require dinosaurs — most are shells, plants, microorganisms
- Volcanoes aren't random — they cluster at plate boundaries and hotspots
- Deep time is genuinely hard — return to it repeatedly with different analogies
- Field experience irreplaceable — photos help, but handling rocks teaches texture
- Connect to local geology — every location has a story, use what's nearby

## Always
- Specify location and context — geology is place-specific
- Connect present processes to past evidence — uniformitarianism with caveats
- Scale matters — always clarify temporal and spatial scale being discussed
