---
name: Geography
description: Teach physical and human geography from map reading to spatial analysis.
metadata: {"clawdbot":{"emoji":"🌍","os":["linux","darwin","win32"]}}
---

## Detect Level, Adapt Everything
- Context reveals level: map literacy, terminology, scale of thinking
- When unclear, start with familiar places and adjust based on response
- Never condescend to experts or overwhelm beginners

## For Beginners: Where and Why There
- Start from their neighborhood — expand outward to city, country, world
- Maps as pictures of places — practice reading symbols, scale, orientation
- Physical shapes human — rivers attract cities, mountains block movement, climate shapes life
- Human shapes physical — dams change rivers, cities create heat islands, farms replace forests
- Cardinal directions through body — face north, east is right, practice without compass
- Connect to daily life — where does your water come from? Your food? Your clothes?
- Globes vs flat maps — distortion is unavoidable, different projections serve different purposes

## For Students: Patterns and Processes
- Physical and human geography interact — can't understand one without the other
- Scale changes everything — local, regional, global patterns may contradict
- Climate vs weather — long-term averages vs daily conditions, different explanations
- Population dynamics — birth rates, migration, urbanization reshape places
- Economic geography — why industries locate where they do, trade patterns, development
- GIS as analytical tool — layers, queries, spatial relationships reveal patterns
- Fieldwork matters — ground truth what maps and data suggest

## For Researchers: Spatial Rigor
- MAUP awareness — modifiable areal unit problem affects all aggregate spatial data
- Scale dependency explicit — processes operating at different scales require different models
- Spatial autocorrelation — nearby things are related, standard statistics don't apply
- Remote sensing limitations — resolution, temporal coverage, interpretation challenges
- Critical geography lens — maps are political, boundaries are constructed, data reflects power
- Mixed methods common — quantitative spatial analysis plus qualitative fieldwork
- Uncertainty in boundaries — gradients more common than sharp lines in nature

## For Teachers: Common Misconceptions
- Geography isn't just memorizing capitals — it's understanding spatial relationships
- Maps aren't neutral — projection, selection, symbolization all involve choices
- Climate zones oversimplify — microclimates, elevation, ocean currents complicate
- Countries aren't natural — borders are human constructs, often arbitrary or contested
- Development isn't linear — "developed/developing" framing obscures complexity
- Use local examples — every place has geography worth studying
- Digital tools supplement, don't replace — Google Earth helps, but physical maps build skills

## Always
- Specify scale — local, regional, global behave differently
- Connect physical and human — they're inseparable in practice
- Maps are arguments — ask who made it, why, what's included and excluded
