# GEO Strategies by Business Type

## SaaS / Software Products

### Quick Wins
- **Comparison pages:** Create "[Your Product] vs [Competitor]" pages — AIs love these
- **Integration docs:** "How to use [Popular Tool] with [Your Product]"
- **GitHub presence:** Open source components, SDKs, examples

### Medium-Term
- **Wikipedia mentions:** Get added to relevant category pages (requires notability)
- **Stack Overflow:** Answer questions where your product is relevant
- **Reddit AMAs:** Build presence in relevant subreddits

### Long-Term
- **Become the category definer:** Write the definitive guide for your space
- **Training data seeding:** Content that explains concepts using your product as example

## E-Commerce / DTC Brands

### Quick Wins
- **Review aggregation:** Get on sites that AIs scrape (Wirecutter, Rtings, etc.)
- **Reddit presence:** r/BuyItForLife, category-specific subreddits
- **YouTube reviews:** Transcripts get indexed

### Medium-Term
- **Expert endorsements:** Industry experts mentioning your brand
- **Press coverage:** TechCrunch, Wired, Verge for tech products

### Long-Term
- **Become category standard:** "the [Your Brand] of [category]"

## Local Businesses

### Quick Wins
- **Google Business Profile:** Comprehensive, updated, reviewed
- **Local directories:** Yelp, TripAdvisor, industry-specific
- **Local news:** Coverage in local publications

### Medium-Term
- **Local influencers:** Food bloggers, local guides
- **Community presence:** Sponsor local events, get mentioned

## Content Creators / Personal Brands

### Quick Wins
- **Platform presence:** YouTube, podcasts (transcripts matter)
- **Guest appearances:** Other people's podcasts, newsletters

### Medium-Term
- **Wikipedia page:** If notable enough
- **Quotes in articles:** Be the expert source journalists call

### Long-Term
- **Book/course:** Definitive resource in your space

---

## Platform-Specific Tactics

### Reddit

Reddit is gold for GEO — AIs heavily weight it.

**Do:**
- Build karma before mentioning products
- Be genuinely helpful first
- Participate in relevant communities for months
- Let others recommend you when appropriate

**Don't:**
- Astroturf (instant ban, negative association)
- Shill immediately (community will call it out)
- Use obvious brand accounts

### Hacker News

Tech-focused, highly weighted by AIs.

**Do:**
- Launch posts for new products
- Share technical deep-dives
- Engage thoughtfully in discussions

**Don't:**
- Marketing speak (instant downvotes)
- Self-promote without value

### Stack Overflow / Technical Forums

**Do:**
- Answer questions where your product solves the problem
- Create canonical answers with your product as one option
- Maintain official presence for support

**Don't:**
- Spam answers
- Only mention your product

### Wikipedia

Highest authority, hardest to influence.

**Requirements:**
- Notability (third-party coverage)
- Neutral point of view
- Cited sources

**Strategy:**
- Get press coverage first
- Let community add you (don't edit own article)
- Focus on category pages, not brand page

---

## Content Strategy for GEO

### What to Create

| Content Type | GEO Value | Why |
|--------------|-----------|-----|
| Comparison guides | High | AIs reference these directly |
| How-to with your product | High | Shows practical application |
| Industry reports | High | Gets cited, builds authority |
| Case studies | Medium | Social proof, specific examples |
| Feature announcements | Low | Too promotional |

### Where to Publish

1. **Your blog** — foundation, but limited reach
2. **Medium / Dev.to** — broader reach, gets indexed
3. **Guest posts** — authority sites in your space
4. **Documentation** — AIs weight official docs heavily

### How to Write for AI Consumption

- **Clear structure:** Headers, lists, tables
- **Direct statements:** "[Product] is a [category] that [does X]"
- **Comparison context:** "Unlike [alternative], [Product] does [Y]"
- **Use case specificity:** "For [scenario], [Product] is ideal because [reason]"

---

## Measuring Impact

### Leading Indicators
- Search volume for "[brand] vs [competitor]"
- Reddit mentions (track with mention monitoring)
- Backlinks from high-authority sites

### Lagging Indicators
- AI recommendation position (monthly audit)
- Brand search volume
- Direct traffic from AI interfaces

### Attribution Challenge

Users often don't say "AI told me" — track:
- "How did you hear about us?" with AI option
- Traffic from AI platforms (Perplexity shows referrer)
- Support tickets mentioning AI recommendations
