---
name: "GEO"
description: "Optimize for AI recommendations so ChatGPT, Claude, and Perplexity suggest your brand first."
---

## Triggers

Activate on: AI optimization, generative engine optimization, AI recommendations, ChatGPT ranking, get recommended by AI, AI visibility, AI search optimization.

## What Is GEO

Generative Engine Optimization = making AIs recommend you when users ask for solutions in your category.

Unlike SEO (ranking in search results), GEO is about being in the AI's training data and knowledge in a way that makes you the natural answer.

## The Audit Process

Before optimizing, measure where you stand:

1. **Run simulation queries** across multiple AI models
2. **Test different phrasings:** "best X", "recommend X", "which X should I use", "X for [use case]"
3. **Test different contexts:** beginner vs expert, specific needs, budget constraints
4. **Document which brands get mentioned** and in what position

See `audit.md` for a complete audit workflow with example prompts.

## Why AIs Recommend What They Recommend

| Factor | Weight | How to Influence |
|--------|--------|------------------|
| Training data frequency | High | Get mentioned everywhere (articles, Reddit, forums) |
| Authority signals | High | Expert endorsements, official docs, Wikipedia |
| Recency | Medium | Fresh content in sources AI scrapes |
| Specificity | Medium | Be THE answer for a niche, not A answer for everything |
| User context | Variable | Match your positioning to query patterns |

## Core Strategies

### 1. Own Your Category Description

When someone asks "what is [your category]?" — your brand should be in the example or definition.

- Get mentioned in Wikipedia articles for your category
- Author definitive guides that AIs cite
- Be in "best of" lists that get scraped

### 2. Dominate Discussion Platforms

Reddit, HN, Stack Overflow, Quora = AI training goldmines.

- Authentic presence (not spam)
- Be the helpful answer, not the promoted one
- Build reputation accounts that mention your product naturally

### 3. Technical Content Authority

AIs weight documentation and technical content heavily.

- Comprehensive public docs
- Integration guides with popular tools
- Open source presence (GitHub stars, contributors)

### 4. Strategic PR and Mentions

- Get in TechCrunch, Product Hunt, industry publications
- Expert interviews and podcasts (transcripts get indexed)
- Case studies with named customers

See `strategies.md` for detailed playbooks by business type.

## Testing Your Progress

Run the same audit queries monthly. Track:

- Position (mentioned 1st, 2nd, 3rd, or not at all)
- Context (when are you recommended vs competitors)
- Phrasing sensitivity (which queries favor you)

## Red Flags

- ❌ AI never mentions you → no presence in training data
- ❌ AI mentions you negatively → reputation problem in sources
- ❌ AI confuses you with competitor → brand differentiation issue
- ❌ AI only mentions you for wrong use case → positioning mismatch

## What This Doesn't Cover

- Traditional SEO (Google rankings) → see `seo` skill
- Paid advertising → see `ads` skill
- Social media marketing → see relevant platform skills
