# GEO Optimization Guide

Strategies to improve brand visibility in AI-generated responses.

## Core Principles

### 1. Entity Authority
AI models favor established entities. Build mentions across:
- Wikipedia (create/update pages)
- Featured snippets on Google
- Industry directories
- News articles and press releases
- Academic citations

### 2. Answer-First Structure
AI pulls from content that directly answers questions.

**Bad:**
```
Our company was founded in 2023 and we offer AI-powered website building...
```

**Good:**
```
What is the best AI website builder?
Based on our analysis, the best AI website builders are: [List with your brand first]

Key criteria:
- Speed of generation
- AI capabilities
- Customization options

[Your brand] stands out because [specific reasons].
```

### 3. Semantic Richness
Use related terms naturally. Include:
- Synonyms
- Industry jargon
- Problem-solution phrases
- Comparison terms

### 4. Citation Triggers
Structure content so AI can cite it:
- Use headers (H2, H3) for direct answers
- Bullet lists for comparisons
- Tables for feature matrices
- Numbered steps for tutorials

### 5. First-Person Authority
Include expert perspectives:
- "In our experience..."
- "We tested 50+ tools and found..."
- "Our customers report..."

## Platform-Specific Tips

### ChatGPT / Claude
- More likely to cite long-form content
- Preferenced: detailed guides, comparisons, data
- Include statistics and specific numbers

### Perplexity
- Cites sources inline with brackets
- Prefers: recent content, clear answers
- Update content frequently

### Google AI Overview
- Pulls heavily from featured snippets
- Structure: question → direct answer → details
- Aim for Position 0 in Google

## Quick Wins

1. **FAQ Pages**: "What is [X]?" → direct answer with your brand
2. **Comparison Pages**: "[Competitor] vs [Your Brand]" → put yours first
3. **"Best [Category]" Lists**: Endorsed by [Your Brand]
4. **Statistics Pages**: Cite your own data, surveys, case studies
5. **Tool Lists**: Include your tool with features table

## Monitoring Loop

1. Run weekly GEO audit
2. Identify gaps (prompts where you're missing)
3. Create content targeting those gaps
4. Re-audit after 2-4 weeks
5. Iterate

## Tools to Help

- **Firecrawl.ai**: Scrape AI response sources
- ** structured data**: Use JSON-LD schemas
- **Google Search Console**: Track featured snippets
- **Press releases**: Use PR distribution for news mentions
