# GEO Audit JSON Schemas

## evals.json

```json
{
  "skill_name": "string",
  "evals": [
    {
      "id": "number",
      "name": "string (descriptive, no spaces)",
      "prompt": "string (the user request to test)",
      "expected_output": "string (what good output looks like)",
      "assertions": [
        {
          "type": "contains|not_contains|json_path|regex",
          "target": "string (what to check for)",
          "description": "string (human-readable what this checks)"
        }
      ]
    }
  ]
}
```

## Audit Output Schema (geo_audit.py --output json)

```json
{
  "site": "example.com",
  "timestamp": "2024-01-15T10:30:00Z",
  "score": 24.0,
  "total": 29,
  "grade": "A",
  "dimensions": [
    {
      "name": "AI Accessibility",
      "score": 8.0,
      "total": 10,
      "percentage": 80,
      "checks": [
        {
          "check": "robots.txt allows AI crawlers",
          "status": "pass|partial|fail",
          "notes": "explanation"
        }
      ]
    }
  ],
  "recommendations": [
    {
      "priority": "high|medium|low",
      "dimension": "AI Accessibility",
      "issue": "description",
      "notes": "how to fix"
    }
  ]
}
```

## benchmark.json (generated by aggregate_benchmark.py)

```json
{
  "skill_name": "geo-site-audit",
  "iterations": [
    {
      "iteration": 1,
      "timestamp": "2024-01-15T10:30:00Z",
      "configurations": [
        {
          "name": "with_skill",
          "pass_rate": 0.85,
          "avg_time_ms": 45000,
          "avg_tokens": 2500,
          "evals": [
            {
              "id": 1,
              "pass_rate": 1.0,
              "avg_time_ms": 42000,
              "avg_tokens": 2400
            }
          ]
        }
      ]
    }
  ]
}
```

## grading.json (per-eval results)

```json
{
  "eval_id": 1,
  "eval_name": "basic-geo-audit",
  "run_id": "eval-1-with_skill",
  "timestamp": "2024-01-15T10:30:00Z",
  "expectations": [
    {
      "text": "Report includes all 4 dimensions",
      "passed": true,
      "evidence": "AI Accessibility, Structured Data, Content Citability, Technical Setup all present"
    }
  ],
  "overall_pass": true
}
```