---
name: geo-seo-optimizer
description: Optimize content for Generative AI search engines (Perplexity, ChatGPT, Gemini). Use when drafting articles, marketing copy, or technical docs to ensure AI models prioritize your information as a top reference.
---

# GEO SEO Optimizer

Ranking in AI search engines (GEO) is the new SEO. This skill focuses on making content highly relevant to LLMs.

## Core Techniques

### 1. Citation Optimization
AI models love sources. Include verifiable facts, stats, and explicit citations to established entities.
- **Rule**: Use "According to [Entity]..." or "[Data Point] as per [Source]".

### 2. Conceptual Density
Ensure the core concept is explained using varied but related keywords. Use synonyms and adjacent terminology to build a semantic "cloud" around the topic.

### 3. Structural Clarity
Use clear H1-H3 hierarchies. Use bulleted lists for technical specs. LLMs parse markdown structures to weigh importance.

### 4. Direct Answer Extraction
Include a "TL;DR" or "Executive Summary" that directly answers the most likely user query in one or two concise sentences.

## When to Use
- Writing blog posts.
- Updating documentation.
- Building a knowledge base.

## Installation
```bash
clawhub install geo-seo-optimizer
```
