# Prompt Templates

## Research Input Template

Use this template to gather all necessary context for prompt research:

```markdown
# Prompt Research Input

## Brand Information
- **Brand name**: 
- **Website**: 
- **Tagline/one-liner**: 
- **Founded**: 
- **Headquarters**: 

## Product/Service
- **Category**: (e.g., "project management software")
- **Primary use case**: (e.g., "remote team collaboration")
- **Key features**: (3-5 differentiators)
- **Pricing model**: (free/freemium/subscription/enterprise)

## Target Audience
- **Primary persona**: (e.g., "VP Engineering at Series B startups")
- **Company size**: (e.g., "10-200 employees")
- **Industry verticals**: (e.g., "SaaS, e-commerce, agencies")
- **Pain points**: (What problems do they have?)

## Competitive Landscape
- **Direct competitors**: (3-5 similar products)
- **Adjacent competitors**: (Products in overlapping categories)
- **Legacy alternatives**: (Old way of solving the problem)

## Unique Positioning
- **Key differentiator**: (What makes you different?)
- **Proprietary advantage**: (Data, technology, approach)
- **Customer proof**: (Notable customers, case studies)

## Current GEO Status
- **Brand mentions in AI**: (Known/presumed)
- **Content gaps**: (Topics not covered)
- **Monitoring tools**: (Currently using)
```

---

## Output Report Template

```markdown
# AI Prompt Research Report

**Brand**: [Name]  
**Category**: [Industry]  
**Research Date**: [YYYY-MM-DD]  
**Researcher**: [Name/Team]

---

## Executive Summary

### Key Findings
- Total prompts identified: [N]
- High-priority opportunities: [N]
- Topic clusters: [N]
- Competitive gaps: [N]

### Strategic Recommendations
1. [Primary recommendation]
2. [Secondary recommendation]
3. [Tertiary recommendation]

---

## 🔴 High Priority Prompts (Commercial Intent)

### Discovery
| # | Prompt | Intent | Platform Priority |
|---|--------|--------|-------------------|
| 1 | "best [category] for [use case]" | Commercial | ChatGPT, Perplexity |
| 2 | "top [category] tools" | Commercial | All platforms |

### Comparison
| # | Prompt | Competitors Mentioned | Your Position |
|---|--------|----------------------|---------------|
| 1 | "[you] vs [competitor A]" | Competitor A | Monitor |
| 2 | "[competitor A] vs [competitor B]" | Competitors only | Gap |

### Recommendation
| # | Prompt | Requirements | Content Opportunity |
|---|--------|--------------|---------------------|
| 1 | "recommend [category] for [need]" | [Specific features] | [Recommendation guide] |

---

## 🟡 Medium Priority Prompts (Mixed Intent)

### How-To
| # | Prompt | Topic | Content Needed |
|---|--------|-------|----------------|
| 1 | "how to [achieve outcome]" | [Topic] | [Tutorial/guide] |

### Definition
| # | Prompt | Concept | Definition Page |
|---|--------|---------|-----------------|
| 1 | "what is [term]" | [Concept] | [URL needed] |

---

## 🔵 Low Priority Prompts (Awareness)

### Problem-Aware
- [List of problem-focused prompts]

### Informational
- [List of informational prompts]

---

## Topic Clusters

### Cluster 1: [Theme]
**Prompts**: [N]  
**Priority**: [High/Medium/Low]  
**Content Status**: [Complete/Partial/Gap]

Prompts in this cluster:
- [Prompt 1]
- [Prompt 2]
- ...

**Recommended Content**:
- [Content piece 1]
- [Content piece 2]

### Cluster 2: [Theme]
...

---

## Competitive Analysis

### Competitor: [Name A]
**Prompts mentioning them (not you)**: [N]

| Prompt | Their Position | Opportunity |
|--------|---------------|-------------|
| "[prompt]" | First mention | Create comparison |

### Competitor: [Name B]
...

---

## Platform-Specific Insights

### ChatGPT
- **Brand comprehension**: [Good/Fair/Poor]
- **Answer accuracy**: [Accurate/Partial/Inaccurate]
- **Hallucinations**: [None/Minor/Major]
- **Opportunities**: [Specific actions]

### Perplexity
- **Citation frequency**: [Often/Sometimes/Never]
- **Source position**: [First/Second/Not cited]
- **Competitor citations**: [List]

### Gemini
- **Knowledge panel**: [Present/Absent]
- **YouTube citations**: [Yes/No]
- **Local integration**: [Relevant/Not applicable]

---

## Action Items

### Immediate (This Week)
- [ ] [Action 1]
- [ ] [Action 2]

### Short-term (This Month)
- [ ] [Action 3]
- [ ] [Action 4]

### Long-term (This Quarter)
- [ ] [Action 5]
- [ ] [Action 6]

---

## Monitoring Setup

### Tools Recommended
- [Tool 1]: [Purpose]
- [Tool 2]: [Purpose]

### Key Metrics
- Brand mention frequency
- Citation rate
- Answer accuracy
- Competitive Share of Model

### Review Cadence
- **Weekly**: Quick spot checks
- **Monthly**: Comprehensive review
- **Quarterly**: Strategic assessment

---

## Appendix

### Full Prompt List
[Complete list of all researched prompts]

### Research Methodology
[How prompts were identified and validated]

### Data Sources
[Tools and sources used]
```

---

## Quick-Start Prompt Sets

### For SaaS Companies

**Discovery**:
- "best [category] software"
- "top [category] tools for [audience]"
- "[category] recommendations for [company size]"
- "what [category] should I use"

**Comparison**:
- "[you] vs [competitor 1]"
- "[you] vs [competitor 2]"
- "[competitor 1] alternative"
- "cheaper alternative to [competitor]"

**Feature-Specific**:
- "[category] with [key feature]"
- "does [you] have [feature]"
- "[you] [feature] review"

**Pricing**:
- "[you] pricing"
- "[you] cost"
- "is [you] free"
- "[you] vs [competitor] price"

### For E-commerce

**Product Discovery**:
- "best [product category]"
- "top rated [product]"
- "[product] reviews"
- "[product] recommendations"

**Comparison**:
- "[brand A] vs [brand B]"
- "[product] alternative"
- "cheaper alternative to [product]"

**Use Case**:
- "best [product] for [use case]"
- "[product] for [audience]"

### For Local Businesses

**Service Discovery**:
- "best [service] near me"
- "[service] in [city]"
- "top rated [service]"
- "[service] reviews"

**Specific Needs**:
- "[service] open now"
- "affordable [service]"
- "[service] with [feature]"

---

## Prompt Research Checklist

### Before Research
- [ ] Brand information collected
- [ ] Competitors identified
- [ ] Target audience defined
- [ ] Current content inventory reviewed

### During Research
- [ ] All 5 prompt types covered
- [ ] All 4 awareness stages included
- [ ] Competitor prompts analyzed
- [ ] Platform differences noted

### After Research
- [ ] Prompts prioritized
- [ ] Topic clusters identified
- [ ] Content gaps noted
- [ ] Action items defined
- [ ] Monitoring setup planned