# Prompt Taxonomy

## The 5 Core Prompt Types

### 1. Discovery Prompts

**Purpose**: Find solutions in a category

**Patterns**:
- "best [category] for [use case]"
- "top [category] tools"
- "[category] recommendations"
- "what [category] should I use"

**Examples**:
- "best CRM for real estate agents"
- "top project management software for startups"
- "email marketing tools for e-commerce"
- "what accounting software should I use for my small business"

**Intent**: Commercial investigation
**AI Platform**: ChatGPT, Perplexity, Gemini
**GEO Priority**: 🔴 High

**Characteristics**:
- User knows the category
- User has a specific use case
- Ready to evaluate options
- High conversion potential

---

### 2. Comparison Prompts

**Purpose**: Compare specific options

**Patterns**:
- "[brand A] vs [brand B]"
- "[brand A] or [brand B]"
- "[brand A] compared to [brand B]"
- "difference between [brand A] and [brand B]"

**Examples**:
- "Salesforce vs HubSpot"
- "Notion or Asana for project management"
- "MacBook Air compared to MacBook Pro"
- "difference between Zoom and Microsoft Teams"

**Intent**: Commercial evaluation
**AI Platform**: Perplexity (citation-heavy), Gemini
**GEO Priority**: 🔴 High

**Characteristics**:
- User is shortlisting
- Specific brands mentioned
- Decision-making stage
- Comparison content opportunity

---

### 3. How-To Prompts

**Purpose**: Learn to achieve an outcome

**Patterns**:
- "how to [achieve outcome]"
- "how do I [solve problem]"
- "steps to [accomplish goal]"
- "guide to [process]"

**Examples**:
- "how to get my brand mentioned in ChatGPT"
- "how do I optimize for AI search"
- "steps to implement GEO strategy"
- "guide to measuring Share of Model"

**Intent**: Informational with commercial potential
**AI Platform**: ChatGPT, Perplexity
**GEO Priority**: 🟡 Medium

**Characteristics**:
- Problem-aware
- Seeks solution method
- Educational content opportunity
- Can lead to tool recommendations

---

### 4. Definition Prompts

**Purpose**: Understand a concept

**Patterns**:
- "what is [term/concept]"
- "explain [concept]"
- "meaning of [term]"
- "define [term]"

**Examples**:
- "what is Generative Engine Optimization"
- "explain Share of Model"
- "meaning of zero-click search"
- "define retrieval-augmented generation"

**Intent**: Informational
**AI Platform**: All platforms (especially ChatGPT)
**GEO Priority**: 🟡 Medium

**Characteristics**:
- Early research stage
- Concept education
- Authority building opportunity
- Can introduce branded terms

---

### 5. Recommendation Prompts

**Purpose**: Get personalized suggestions

**Patterns**:
- "recommend a [product] for [need]"
- "suggest [category] for [situation]"
- "what [product] should I choose"
- "looking for [category] that [requirement]"

**Examples**:
- "recommend a laptop for video editing under $2000"
- "suggest a CRM for a 5-person sales team"
- "what email tool should I choose for drip campaigns"
- "looking for project management software that integrates with GitHub"

**Intent**: Commercial with specific requirements
**AI Platform**: ChatGPT, Perplexity
**GEO Priority**: 🔴 High

**Characteristics**:
- Specific constraints mentioned
- Personalized need
- Ready to purchase
- Feature comparison likely

---

## Prompt Variations by Audience Awareness

### Problem-Aware Stage

User knows they have a problem but doesn't know solutions exist.

**Prompt Patterns**:
- "why is [problem happening]"
- "how to fix [problem]"
- "[problem] solutions"
- "dealing with [problem]"

**Examples**:
- "why are my marketing emails going to spam"
- "how to fix low email open rates"
- "team communication problems solutions"
- "dealing with project scope creep"

**Content Strategy**: Educational, problem-focused
**GEO Priority**: 🟡 Medium

---

### Solution-Aware Stage

User knows solutions exist but is exploring options.

**Prompt Patterns**:
- "best [solution type]"
- "[solution type] tools"
- "how to choose [solution type]"
- "[solution type] reviews"

**Examples**:
- "best email marketing platforms"
- "project management tools for remote teams"
- "how to choose a CRM"
- "email automation software reviews"

**Content Strategy**: Category education, comparison frameworks
**GEO Priority**: 🔴 High

---

### Product-Aware Stage

User knows about specific products and is evaluating.

**Prompt Patterns**:
- "[brand] reviews"
- "[brand] pricing"
- "[brand] vs [competitor]"
- "is [brand] worth it"

**Examples**:
- "HubSpot reviews"
- "Salesforce pricing"
- "Asana vs Monday.com"
- "is Notion worth it for personal use"

**Content Strategy**: Product-specific content, comparisons
**GEO Priority**: 🔴 High

---

### Brand-Aware Stage

User knows your brand and is investigating specifics.

**Prompt Patterns**:
- "[brand] [feature]"
- "does [brand] [capability]"
- "[brand] [integration]"
- "[brand] alternatives"

**Examples**:
- "HubSpot workflow automation"
- "does Asana have time tracking"
- "Salesforce Slack integration"
- "Mailchimp alternatives"

**Content Strategy**: Feature documentation, use cases, alternatives
**GEO Priority**: 🟡 Medium

---

## Prompt Modifiers

Modifiers change the intent or specificity of base prompts.

### Use Case Modifiers

| Modifier | Example | Intent Shift |
|----------|---------|--------------|
| "for [audience]" | "best CRM for real estate" | More specific |
| "for [use case]" | "laptop for video editing" | Use case focused |
| "for [size]" | "project tool for enterprise" | Scale specific |
| "for [budget]" | "CRM under $50/month" | Price sensitive |

### Constraint Modifiers

| Modifier | Example | Intent Shift |
|----------|---------|--------------|
| "with [feature]" | "email tool with A/B testing" | Feature requirement |
| "without [limitation]" | "CRM without contact limits" | Avoidance |
| "that integrates with [tool]" | "PM tool that integrates with Slack" | Integration need |
| "alternative to [brand]" | "alternative to Salesforce" | Comparison |

### Quality Modifiers

| Modifier | Example | Intent Shift |
|----------|---------|--------------|
| "best" | "best project management software" | Quality focused |
| "cheapest" | "cheapest email marketing" | Price focused |
| "easiest" | "easiest CRM to set up" | Usability focused |
| "most popular" | "most popular CRM" | Social proof |

---

## Prompt Clustering

Group related prompts to identify content themes.

### Example: CRM Cluster

```
Discovery
├── "best CRM software"
├── "top CRM for small business"
└── "CRM recommendations for sales teams"

Comparison
├── "Salesforce vs HubSpot"
├── "HubSpot vs Zoho"
└── "Pipedrive compared to Salesforce"

Features
├── "CRM with email integration"
├── "CRM with workflow automation"
└── "does HubSpot have API access"

Pricing
├── "Salesforce pricing"
├── "HubSpot free vs paid"
└── "cheapest CRM for startups"
```

### Clustering Benefits

1. **Content planning**: Create comprehensive guides per cluster
2. **Internal linking**: Connect related content
3. **Monitoring**: Track visibility by topic area
4. **Gap analysis**: Identify underrepresented themes

---

## Prompt Intent Classification

### Informational
- User seeks knowledge
- No immediate purchase intent
- Educational content opportunity

**Examples**: "what is GEO", "how does AI search work"

### Commercial Investigation
- User researching options
- Evaluating before purchase
- Comparison content opportunity

**Examples**: "best GEO tools", "GEOly vs BrightEdge"

### Transactional
- User ready to buy
- Specific product/brand focus
- Conversion content opportunity

**Examples**: "GEOly pricing", "sign up for GEOly"

### Navigational
- User looking for specific site/page
- Brand or product name included
- Ensure findability

**Examples**: "GEOly login", "GEOly documentation"