# Research Examples

## Example 1: SaaS Project Management Tool

### Input

**Brand**: FlowTrack  
**Category**: Project management software  
**Target Audience**: Software engineering teams (10-200 people)  
**Key Features**: Sprint planning, Git integration, release management  
**Competitors**: Asana, Monday.com, Jira, Linear, Notion

### Research Output

---

# AI Prompt Research Report: FlowTrack

**Brand**: FlowTrack  
**Category**: Project Management Software  
**Research Date**: 2024-02-15

---

## Executive Summary

- **Total prompts identified**: 156
- **High-priority opportunities**: 42
- **Topic clusters**: 8
- **Critical gap**: Missing from "vs Linear" comparisons

### Top Opportunity
"best project management software for software teams" — 4,400 monthly AI queries, FlowTrack not mentioned in top 5

---

## 🔴 High Priority Prompts

### Discovery (12 prompts)

| # | Prompt | Est. Volume | Current Position |
|---|--------|-------------|------------------|
| 1 | "best project management software for software teams" | 4,400/mo | Not mentioned |
| 2 | "top project management tools for developers" | 2,900/mo | Not mentioned |
| 3 | "best alternative to Jira for agile teams" | 1,600/mo | #3 (opportunity) |
| 4 | "project management tool with Git integration" | 880/mo | #2 |
| 5 | "best sprint planning tool" | 720/mo | Not mentioned |

### Comparison (18 prompts)

| # | Prompt | Competitors Cited | FlowTrack Position |
|---|--------|-------------------|-------------------|
| 1 | "Asana vs Monday.com" | Both mentioned | Not present |
| 2 | "Linear vs Jira" | Both mentioned | Not present |
| 3 | "Notion vs Asana for engineering" | Both mentioned | Not present |
| 4 | "FlowTrack vs Linear" | Linear only | Gap! |
| 5 | "best Jira alternative" | 5 tools mentioned | Not present |

### Recommendation (8 prompts)

| # | Prompt | Requirements | Opportunity |
|---|--------|--------------|-------------|
| 1 | "recommend a project tool for 20-person dev team" | GitHub integration, sprints | High |
| 2 | "what PM tool should I choose for agile development" | Scrum support, reporting | High |
| 3 | "looking for Jira alternative that's easier to use" | Simple, fast onboarding | High |

---

## 🟡 Medium Priority Prompts

### How-To (15 prompts)

| # | Prompt | Content Needed |
|---|--------|----------------|
| 1 | "how to plan sprints effectively" | Sprint planning guide |
| 2 | "how to integrate GitHub with project management" | Integration tutorial |
| 3 | "how to reduce deployment time" | DevOps guide |
| 4 | "how to manage remote engineering teams" | Remote work guide |

### Definition (4 prompts)

| # | Prompt | Definition Page Status |
|---|--------|------------------------|
| 1 | "what is sprint planning" | Not on FlowTrack site |
| 2 | "what is release management" | Basic page exists |
| 3 | "what is velocity in agile" | Not on FlowTrack site |

---

## Topic Clusters

### Cluster 1: Sprint Planning (23 prompts)
**Priority**: 🔴 High  
**Content Status**: Gap

Prompts:
- "best sprint planning tool"
- "how to plan sprints"
- "sprint planning template"
- "sprint planning vs release planning"
- "automated sprint planning"

**Recommended Content**:
- "The Complete Guide to Sprint Planning" (pillar)
- "Sprint Planning Templates for Engineering Teams"
- "FlowTrack vs [Competitors] for Sprint Planning"

### Cluster 2: Git Integration (18 prompts)
**Priority**: 🔴 High  
**Content Status**: Partial

Prompts:
- "project management with GitHub integration"
- "connect GitLab to project tool"
- "best PM tool for developers"
- "git-based project management"

**Recommended Content**:
- "How FlowTrack's Git Integration Works" (feature page)
- "10 Ways to Connect Your Code to Your Project Management"

### Cluster 3: Jira Migration (15 prompts)
**Priority**: 🔴 High  
**Content Status**: Gap

Prompts:
- "best Jira alternative"
- "how to migrate from Jira"
- "Jira vs modern tools"
- "easier alternative to Jira"

**Recommended Content**:
- "The Jira Migration Guide" (comprehensive)
- "FlowTrack vs Jira: 2024 Comparison"
- "Why Teams Are Leaving Jira (And Where They're Going)"

### Cluster 4: Agile/Scrum (19 prompts)
**Priority**: 🟡 Medium  
**Content Status**: Partial

Prompts:
- "what is velocity in agile"
- "how to calculate sprint capacity"
- "scrum vs kanban"
- "agile project management best practices"

### Cluster 5: Team Size Specific (12 prompts)
**Priority**: 🟡 Medium  
**Content Status**: Gap

Prompts:
- "best project tool for startup"
- "project management for 10-person team"
- "enterprise project management"

### Cluster 6: Pricing/Cost (14 prompts)
**Priority**: 🟡 Medium  
**Content Status**: Complete

Prompts:
- "FlowTrack pricing"
- "cheaper alternative to Asana"
- "free project management tool"

### Cluster 7: Integrations (20 prompts)
**Priority**: 🟡 Medium  
**Content Status**: Partial

Prompts:
- "project management Slack integration"
- "connect Notion to Jira"
- "Zapier project management"

### Cluster 8: Remote Work (11 prompts)
**Priority**: 🔵 Low  
**Content Status**: Gap

Prompts:
- "managing remote engineering teams"
- "async project management"
- "remote team collaboration tools"

---

## Competitive Analysis

### Asana
**Strengths**: High brand awareness, strong content marketing  
**Prompts dominating**: "best project management software", "Asana vs Monday.com"

### Monday.com
**Strengths**: Heavy advertising, broad use cases  
**Prompts dominating**: "best project tool", "Monday.com vs Asana"

### Linear
**Strengths**: Developer-focused, high satisfaction  
**Prompts dominating**: "best tool for software teams", "Linear vs Jira"

**Critical Gap**: FlowTrack not appearing in "vs Linear" comparisons despite similar positioning

### Jira
**Strengths**: Enterprise presence, established brand  
**Prompts dominating**: "enterprise project management", "Jira alternatives"

---

## Platform-Specific Findings

### ChatGPT
- **Brand comprehension**: Poor — often confuses with generic "flow" tools
- **Answer example**: "Some popular project management tools include Asana, Monday.com, Trello, and Jira."
- **Gap**: FlowTrack not in training data examples

### Perplexity
- **Citation rate**: Never cited in 20 test queries
- **Competitors cited**: Asana (12x), Monday.com (10x), Linear (8x), Jira (15x)
- **Gap**: No authoritative content being sourced

### Gemini
- **Knowledge panel**: Not present
- **YouTube presence**: 2 videos, low views
- **Gap**: Insufficient multimedia content

---

## Immediate Actions

### This Week
1. **Create comparison page**: "FlowTrack vs Linear for Engineering Teams"
2. **Optimize existing**: Update sprint planning content with FAQ schema
3. **Fix brand confusion**: Add disambiguation on homepage

### This Month
1. **Publish pillar content**: "Complete Guide to Sprint Planning"
2. **Create migration resource**: "Jira to FlowTrack Migration Guide"
3. **Launch video series**: YouTube tutorials for top 10 how-to prompts

### This Quarter
1. **Comparison campaign**: Target all "[competitor] vs [competitor]" gaps
2. **Definition pages**: Build out agile glossary
3. **Integration marketplace**: Expand integration content

---

## Example 2: E-commerce Brand (Outdoor Gear)

### Input

**Brand**: TrailBlaze Co.  
**Category**: Outdoor gear and apparel  
**Target Audience**: Hikers and backpackers (ages 25-45)  
**Key Products**: Ultralight tents, sleeping bags, backpacks  
**Competitors**: REI, Patagonia, Arc'teryx, Osprey

### Key Findings

**Top Prompts**:
1. "best ultralight tent for backpacking" (6,600/mo)
2. "best sleeping bag for cold weather" (4,400/mo)
3. "Osprey vs Gregory backpacks" (2,900/mo)
4. "lightweight backpacking gear list" (2,400/mo)

**Critical Gap**: Not appearing in "best [product]" discovery prompts despite quality products

**Opportunity**: High volume of "how to choose" prompts with no clear winner

---

## Example 3: B2B Services (Marketing Agency)

### Input

**Brand**: GrowthStack Agency  
**Category**: Performance marketing agency  
**Target Audience**: B2B SaaS companies ($5-50M ARR)  
**Services**: Paid acquisition, CRO, marketing automation  
**Competitors**: Demand Curve, Refine Labs, KlientBoost

### Key Findings

**Top Prompts**:
1. "best SaaS marketing agency" (1,900/mo)
2. "B2B paid acquisition agency" (880/mo)
3. "marketing agency vs in-house" (720/mo)
4. "how to choose a marketing agency" (590/mo)

**Unique Opportunity**: High volume of "how much does" pricing prompts — transparency opportunity

**Platform Difference**: Perplexity heavily favors agencies with published case studies and data