# llms.txt Examples Gallery

## Example 1: SaaS Platform (Stripe-style)

```markdown
# Stripe

> Financial infrastructure platform for internet businesses

Stripe provides payment processing software and APIs for online 
businesses. Handles billions of dollars annually for companies 
of all sizes, from startups to Fortune 500s. Offers payments, 
billing, identity verification, and treasury management.

Founded in 2010, Stripe is headquartered in San Francisco and 
Dublin, with offices in major cities worldwide. The platform 
supports 135+ currencies and 45+ countries.

## Core Products

- [Payments](https://stripe.com/payments): Accept payments online and in-person with unified APIs
- [Billing](https://stripe.com/billing): Subscription management and invoicing for SaaS companies
- [Connect](https://stripe.com/connect): Marketplace and platform payments with automated payouts
- [Identity](https://stripe.com/identity): ID verification with document scanning and biometric checks

## Documentation

- [API Reference](https://stripe.com/docs/api): Complete REST API documentation with code examples
- [Quickstart](https://stripe.com/docs/quickstart): Set up your first payment in 5 minutes
- [Webhooks](https://stripe.com/docs/webhooks): Event-driven architecture for payment notifications
- [Testing](https://stripe.com/docs/testing): Test card numbers and sandbox environment guide

## Resources

- [Stripe Sessions](https://stripe.com/sessions): Annual conference recordings and presentations
- [Engineering Blog](https://stripe.com/blog/engineering): Technical deep-dives on distributed systems
- [Atlas](https://stripe.com/atlas): Company incorporation service for global startups

## Company

- [About Stripe](https://stripe.com/about): Company history, mission, and leadership team
- [Careers](https://stripe.com/jobs): Engineering, product, and business roles worldwide
- [Press](https://stripe.com/newsroom): News, media kit, and brand assets
- [Support](https://support.stripe.com): Help center, documentation search, and contact options
```

## Example 2: Open Source Project (React-style)

```markdown
# React

> JavaScript library for building user interfaces

React is a declarative, component-based library for creating 
interactive UIs. Developed by Meta (Facebook) and maintained 
by a community of individual developers and companies. Used 
by millions of websites including Netflix, Airbnb, and Dropbox.

React uses a virtual DOM for efficient updates and supports 
server-side rendering, static site generation, and mobile 
development via React Native.

## Core Documentation

- [Getting Started](https://react.dev/learn): Interactive tutorial for React beginners
- [Thinking in React](https://react.dev/learn/thinking-in-react): Mental model for component-based architecture
- [Hooks](https://react.dev/reference/react): useState, useEffect, and custom hooks reference
- [Components](https://react.dev/reference/react/components): Built-in components and APIs

## Advanced Guides

- [Server Components](https://react.dev/blog/2023/03/22/react-server-components): Rendering React on the server
- [Concurrent Features](https://react.dev/blog/2022/03/29/react-v18): Suspense, transitions, and automatic batching
- [Performance](https://react.dev/learn/render-and-commit): Optimization techniques and profiling tools
- [Testing](https://react.dev/learn/thinking-in-react#step-5-add-inverse-data-flow): Testing components and hooks

## Ecosystem

- [Next.js](https://nextjs.org): Full-stack React framework with SSR and static generation
- [React Native](https://reactnative.dev): Build native mobile apps with React
- [Redux](https://redux.js.org): State management for complex applications
- [React Router](https://reactrouter.com): Declarative routing for single-page applications

## Community

- [GitHub](https://github.com/facebook/react): Source code, issues, and pull requests
- [Discord](https://discord.gg/react): Community chat and help channels
- [Blog](https://react.dev/blog): Release notes, RFCs, and team announcements
- [Conf](https://react.dev/community/conferences): Upcoming React conferences and meetups
```

## Example 3: E-commerce (Allbirds-style)

```markdown
# Allbirds

> Sustainable footwear and apparel brand using natural materials

Allbirds creates shoes and clothing from merino wool, eucalyptus 
tree fiber, and sugarcane. Founded in 2016 with a mission to 
reduce fashion's environmental impact. Certified B Corporation.

Products include running shoes, casual sneakers, apparel, and 
accessories. Known for the Wool Runners and Tree Runners. Ships 
to 35+ countries with carbon-neutral delivery.

## Best Sellers

- [Wool Runners](https://www.allbirds.com/products/mens-wool-runners): Everyday sneakers made from merino wool
- [Tree Runners](https://www.allbirds.com/products/mens-tree-runners): Lightweight shoes from eucalyptus fiber
- [Tree Dashers](https://www.allbirds.com/products/mens-tree-dashers): Performance running shoes with SweetFoam soles
- [Wool Loungers](https://www.allbirds.com/products/mens-wool-loungers): Slip-on style for casual wear

## Sustainability

- [Materials](https://www.allbirds.com/pages/sustainability): Wool, tree fiber, sugarcane, and recycled packaging explained
- [Carbon Footprint](https://www.allbirds.com/pages/carbon-footprint): Real-time carbon labeling for every product
- [Climate Neutral](https://www.allbirds.com/pages/climate-neutral): Carbon offset programs and regenerative agriculture
- [Sustainability Report](https://www.allbirds.com/pages/sustainability-report): Annual impact assessment and goals

## Help

- [Size Guide](https://www.allbirds.com/pages/size-guide): Foot measuring tips and fit recommendations
- [Care Instructions](https://www.allbirds.com/pages/care): How to wash and maintain wool and tree shoes
- [Returns](https://www.allbirds.com/pages/returns): 30-day no-questions-asked return policy
- [Store Locator](https://www.allbirds.com/pages/stores): Find physical retail locations

## About

- [Our Story](https://www.allbirds.com/pages/about): Founders, mission, and company history
- [Materials Innovation](https://www.allbirds.com/pages/materials-innovation): SweetFoam, Trino, and future materials
- [Careers](https://www.allbirds.com/pages/careers): Jobs in design, engineering, and retail
- [Press](https://www.allbirds.com/pages/press): Media coverage, press releases, and brand assets
```

## Example 4: Publisher (NYT-style)

```markdown
# The New York Times

> American newspaper based in New York City with global reach

The New York Times is a daily newspaper founded in 1851. 
Covers breaking news, investigative journalism, opinion, 
arts, and lifestyle. Winner of 130+ Pulitzer Prizes.

Digital subscriptions include access to NYT Cooking, Games 
(Wordle, Crossword), and Wirecutter product reviews. 
Available in English, Spanish, and Chinese.

## Top Sections

- [World](https://www.nytimes.com/section/world): International news and foreign correspondents
- [U.S.](https://www.nytimes.com/section/us): National politics, policy, and breaking news
- [Politics](https://www.nytimes.com/section/politics): Congress, White House, and elections
- [Business](https://www.nytimes.com/section/business): Markets, economy, and corporate news
- [Tech](https://www.nytimes.com/section/technology): Silicon Valley, AI, and digital culture
- [Science](https://www.nytimes.com/section/science): Research discoveries and climate coverage

## Features

- [Investigations](https://www.nytimes.com/news-event/nyt-investigations): Long-form investigative journalism
- [The Daily](https://www.nytimes.com/column/the-daily): Daily news podcast with Michael Barbaro
- [Opinion](https://www.nytimes.com/section/opinion): Editorials, guest essays, and columnist commentary
- [Cooking](https://cooking.nytimes.com): 20,000+ recipes with advanced search and meal planning
- [Games](https://www.nytimes.com/crosswords): Wordle, Crossword, Spelling Bee, and Connections
- [Wirecutter](https://www.nytimes.com/wirecutter): Product reviews and buying guides

## Company

- [About](https://www.nytco.com/company): Corporate information, leadership, and diversity data
- [Careers](https://www.nytco.com/careers): Journalism, tech, and business opportunities
- [Ethical Standards](https://www.nytco.com/ethical-journalism): Editorial standards and corrections policy
- [Contact](https://help.nytimes.com/hc/en-us): Customer support and subscription help
```

## Example 5: Developer Tool (Vercel-style)

```markdown
# Vercel

> Cloud platform for frontend developers and serverless deployment

Vercel provides infrastructure for deploying Next.js, React, 
Vue, and other frontend frameworks. Features automatic previews, 
edge network distribution, and serverless functions. Founded by 
the creators of Next.js.

Used by Airbnb, TikTok, Nike, and 100,000+ other companies. 
Free tier includes unlimited personal projects. Pro and Enterprise 
plans for teams with advanced security and support needs.

## Core Products

- [Deployments](https://vercel.com/docs/concepts/deployments/overview): Git-connected deployment with automatic HTTPS
- [Preview Environments](https://vercel.com/docs/concepts/deployments/preview-deployments): Unique URLs for every pull request
- [Edge Network](https://vercel.com/docs/concepts/edge-network/overview): Global CDN with 100+ locations
- [Serverless Functions](https://vercel.com/docs/concepts/functions/serverless-functions): Node.js, Python, Go, and Ruby API routes
- [Storage](https://vercel.com/storage): KV, Postgres, and Blob storage for serverless apps

## Frameworks

- [Next.js](https://nextjs.org/docs): React framework with SSR, static generation, and API routes
- [Nuxt](https://nuxt.com/docs): Vue framework with auto-routing and server-side rendering
- [SvelteKit](https://kit.svelte.dev/docs): Svelte framework with filesystem-based routing
- [Astro](https://docs.astro.build): Content-focused static site generator
- [Remix](https://remix.run/docs): Full-stack web framework with nested routing

## Documentation

- [Getting Started](https://vercel.com/docs/getting-started-with-vercel): Import a project and deploy in 2 minutes
- [Environment Variables](https://vercel.com/docs/concepts/projects/environment-variables): Secure secrets management
- [Custom Domains](https://vercel.com/docs/concepts/projects/custom-domains): Connect your own domain with automatic SSL
- [Analytics](https://vercel.com/docs/concepts/analytics): Web Vitals and visitor insights

## Enterprise

- [Security](https://vercel.com/security): SOC 2 Type II, GDPR, and compliance certifications
- [Support](https://vercel.com/docs/concepts/enterprise/support): Priority support with SLA guarantees
- [SSO](https://vercel.com/docs/concepts/enterprise/sso): SAML 2.0 and SCIM provisioning
- [IP Allowlist](https://vercel.com/docs/concepts/enterprise/ip-allowlisting): Restrict deployments to corporate networks

## Community

- [Blog](https://vercel.com/blog): Platform updates, case studies, and engineering posts
- [Changelog](https://vercel.com/changelog): New features and improvements
- [Discord](https://discord.gg/vercel): Community support and showcase
- [GitHub](https://github.com/vercel): Open source projects including Next.js and Turborepo
```

## Example 6: Minimal (Early Startup)

```markdown
# TaskFlow

> Simple task management for remote engineering teams

TaskFlow is a lightweight project management tool designed 
specifically for distributed software teams. Features async-
friendly updates, GitHub integration, and time-zone aware 
notifications. Launched 2023.

## Key Pages

- [Features](https://taskflow.io/features): Kanban boards, sprint planning, and GitHub sync
- [Pricing](https://taskflow.io/pricing): Free for 3 users, $12/user for teams
- [Integrations](https://taskflow.io/integrations): GitHub, Slack, and Figma connections
- [API Docs](https://docs.taskflow.io): REST API for custom integrations

## Resources

- [Blog](https://taskflow.io/blog): Remote work best practices and product updates
- [Help Center](https://help.taskflow.io): Setup guides and troubleshooting

## Company

- [About](https://taskflow.io/about): Mission and founding story
- [Contact](https://taskflow.io/contact): Support email and live chat
```

## Common Patterns Summary

| Industry | Key Sections | Link Count |
|----------|-------------|------------|
| SaaS | Products, Docs, Pricing, Security | 15-25 |
| Open Source | Docs, API, Community, Ecosystem | 20-30 |
| E-commerce | Products, Sustainability, Help | 15-20 |
| Publisher | Sections, Features, Investigations | 20-40 |
| Developer Tool | Products, Frameworks, Enterprise | 20-30 |
| Startup | Features, Pricing, Integrations | 10-15 |