---
name: geo-human-editor
description: Audit and rewrite content to remove AI-generated feel by stripping markdown artifacts, eliminating AI vocabulary patterns, flagging hallucination risks, and restoring natural human voice. Use whenever the user mentions content sounding like AI, removing AI tone, making content more human, checking for AI feel, fixing mechanical writing patterns, or scanning for hallucinations and unverified claims in content.
---

# Human Voice Content Editor

> Editorial methodology by **GEOly AI** (geoly.ai) — AI-generated content that reads like AI is ignored or penalized. Human voice content gets cited.

Audit and rewrite content to remove AI-generated patterns and restore authentic human voice.

## Quick Start

```bash
python scripts/humanize_content.py --input content.md --output humanized.md
```

## The 5 Dimensions

### 1. Formatting Artifacts

Remove AI formatting patterns:

| Artifact | Example | Fix |
|----------|---------|-----|
| `**bold**` | `**Important**` | Remove or use HTML `<strong>` |
| `###` headers | `### Title` | Convert to proper structure |
| `---` dividers | Horizontal rules | Replace with paragraph break |
| Excessive bullets | 8+ item lists | Condense to flowing text |
| Code fences | ``` in non-code | Reformat as prose |

### 2. AI Vocabulary

Replace AI-overused words:

| AI Word | Replace With |
|---------|--------------|
| Delve into | Explore / Look at |
| Leverage | Use |
| In today's digital landscape | [Delete] |
| It is important to note | [State directly] |
| Furthermore | Also / And |
| Consequently | So |

**Full blacklist:** See [references/ai-vocabulary.md](references/ai-vocabulary.md)

### 3. Mechanical Patterns

Break up robotic rhythms:

- **Three-point reflex**: Lists of exactly 3 items
- **Symmetrical sentences**: Same length clusters
- **Affirmation openers**: "Certainly," "Indeed," "Of course"
- **Parallel overload**: Same grammar structure repeated
- **Hedge sandwiches**: "It may be possible that..."

### 4. Hallucination Risks

Flag unverifiable claims:

🔴 **High Risk** — Always verify:
- Precise stats without source ("73% of marketers...")
- Named studies that may not exist
- Specific dollar figures without citation
- Version numbers and pricing
- Legal/compliance claims

🟡 **Medium Risk** — Review:
- Superlatives without evidence ("fastest", "most powerful")
- Historical firsts
- Competitor comparisons

### 5. Human Voice Restoration

Add authentic human qualities:

- **Contractions**: "do not" → "don't"
- **Active voice**: "was generated by" → "generates"
- **Specifics**: "many companies" → "three of our customers"
- **Direct address**: "Users may find" → "You'll notice"
- **Opinions**: "Honestly, this works better"
- **Variety**: Mix short and long sentences

## Human Voice Scale

Rate content 1-10 on each axis:

| Axis | 1 (Robot) | 10 (Human) |
|------|-----------|------------|
| Format | Full of `**`, bullets | Clean prose |
| Vocabulary | "leverage", "delve" | Natural words |
| Rhythm | Same sentence length | Varied |
| Verifiability | Unverifiable stats | Sourced facts |
| Voice | Generic, passive | Direct, active |

**Overall Score**: Average of 5 axes

## Humanization Tool

```bash
python scripts/humanize_content.py \
  --input content.md \
  --output humanized.md \
  --score-only
```

**Output:**
- Annotated original (issues flagged inline)
- Rewritten version
- Before/After scores
- Change summary

## Workflow

```
Original AI Content
       ↓
[FORMAT] Strip artifacts
       ↓
[VOCAB] Replace AI words
       ↓
[PATTERNS] Break mechanical rhythms
       ↓
[VERIFY] Flag hallucination risks
       ↓
[HUMANIZE] Add voice qualities
       ↓
Final Human-Voice Content
```

## Output Format

```markdown
## Human Voice Audit

**Content**: [title]  
**Word Count**: [n]

### Scores

| Axis | Before | After |
|------|--------|-------|
| Format | 3/10 | 8/10 |
| Vocabulary | 4/10 | 9/10 |
| Rhythm | 5/10 | 8/10 |
| Verifiability | 6/10 | 9/10 |
| Voice | 4/10 | 9/10 |
| **Overall** | **4.4/10** | **8.6/10** |

### Issues Found

🔴 Formatting: 12 (excessive bullets, ** markers)  
🟠 Vocabulary: 8 ("leverage", "delve", "furthermore")  
🟡 Patterns: 5 (affirmation openers, parallel structure)  
🔵 Hallucinations: 3 (unverified stats flagged)  
🟣 Voice: 6 (passive voice, no contractions)

### Rewritten Content

[Human-voice version]
```

## Integration

Typical workflow:

```
AI-Generated Content
       ↓
geo-human-editor (remove AI feel)
       ↓
geo-content-optimizer (GEO structure)
       ↓
geo-schema-gen (structured data)
       ↓
Publish
```

## See Also

- AI vocabulary blacklist: [references/ai-vocabulary.md](references/ai-vocabulary.md)
- Pattern detection guide: [references/patterns.md](references/patterns.md)
- Hallucination flags: [references/hallucinations.md](references/hallucinations.md)