# Slideshow Prompt Templates

Use these templates when generating slideshows via the genviral API. Before using any template:

1. Read `workspace/context/product.md` to know the product, features, and audience.
2. Read `workspace/context/brand-voice.md` to match the correct tone.
3. Replace ALL placeholders with product-specific content. Never send placeholders to the API.

## Mandatory Pack Image Selection Workflow

If you are using a pack for slideshow backgrounds, this is required. **Do not skip any step.**

1. Run `genviral.sh get-pack --id PACK_ID` and collect all `images[].url` and `images[].metadata` values.
2. **Use AI metadata first:** Read each image's `metadata.description` and `metadata.keywords` to understand what it shows. This lets you shortlist candidates without fetching every image visually.
3. **Use vision tools when needed:** For images with `pending`/`failed` metadata, or when you need to assess readability (clean space, background complexity, text overlay suitability), use a vision/image tool.
4. Plan your slides first (hook text, body text per slide), then map the best-matching image to each slide based on metadata + visual analysis.
5. Consider for each match:
   - Does the image's description/keywords relate to the slide's message?
   - Is there space for readable text? (vision tool helps here)
   - Is the composition visually appealing?
6. Do not pick randomly and do not reuse near-identical images unless deliberate.
7. **Use `pinned_images` in `slide_config`** when calling `generate` to force the server to use your chosen images. Without `pinned_images`, the server picks randomly from the pack and your analysis is wasted. See SKILL.md "Smart Image Selection From Packs" for the exact command format.

## Template 1: Person + Conflict (6 slides)

Best for: Person + conflict hooks where someone doubts the product and gets proven wrong.

```
Create a 6-slide TikTok photo carousel about [PRODUCT NAME], [ONE SENTENCE PRODUCT DESCRIPTION].

Story arc:
Slide 1 (Hook): "[PERSON] said [DOUBT/OBJECTION]..."
Slide 2 (Setup): Show why they thought that. What was the problem or misconception?
Slide 3 (Discovery): "So I showed them [PRODUCT]" or "Then I opened the app"
Slide 4 (Feature): Show the specific feature that solves the problem. [FEATURE DESCRIPTION]
Slide 5 (Result): The transformation. "[PERSON]'s reaction" or "Now they [POSITIVE OUTCOME]"
Slide 6 (CTA): "[CTA TEXT - e.g., Link in bio, Try it free]"

Rules:
- Keep text short. Max 15 words per slide.
- Use [BRAND VOICE DESCRIPTION - e.g., casual, conversational] language. Talk like a friend, not a brand.
- Never use corporate jargon or marketing speak.
- Slide 1 must create curiosity. Make them want to swipe.
- Each slide should be readable in under 3 seconds.
- Do not use em-dashes.
```

### How to fill this template:

Replace:
- `[PRODUCT NAME]` with the product name from product.md
- `[ONE SENTENCE PRODUCT DESCRIPTION]` with the one-liner from product.md
- `[PERSON]` with a relatable character (roommate, mom, friend, coworker, etc.)
- `[DOUBT/OBJECTION]` with a specific objection related to the product's problem space
- `[FEATURE DESCRIPTION]` with a key feature from product.md
- `[CTA TEXT]` with the standard CTA
- `[BRAND VOICE DESCRIPTION]` with the voice from brand-voice.md

---

## Template 2: Educational / Tips (6 slides)

Best for: Listicle-style content teaching useful tips related to the product's problem space.

```
Create a 6-slide TikTok photo carousel with tips about [TOPIC RELATED TO PRODUCT].

Topic: [SPECIFIC TOPIC]

Slide 1 (Hook): "[HOOK - attention-grabbing claim, number, or question]"
Slide 2 (Tip 1): First tip with a brief, specific explanation
Slide 3 (Tip 2): Second tip with a brief, specific explanation
Slide 4 (Tip 3): Third tip with a brief, specific explanation
Slide 5 (Solution): "Or just use [PRODUCT] to [BENEFIT SUMMARY]" - introduce the product naturally
Slide 6 (CTA): "[CTA TEXT]"

Rules:
- Each tip should be specific and actionable, not obvious
- Use surprising facts or counterintuitive advice when possible
- The product mention on slide 5 should feel like a natural conclusion, not a hard sell
- Keep text short. Max 15 words per slide.
- [BRAND VOICE DESCRIPTION] tone throughout
- Do not use em-dashes.
```

---

## Template 3: Before / After (6 slides)

Best for: Transformation content showing the impact of using the product.

```
Create a 6-slide TikTok photo carousel showing a before/after transformation with [PRODUCT NAME].

Topic: [TRANSFORMATION TOPIC - e.g., time saved, money saved, stress reduced, results improved]

Slide 1 (Hook): "[BEFORE vs AFTER claim with specific metric or situation]"
Slide 2 (Before - Problem): What it looked like before. Be specific with numbers or situations.
Slide 3 (Before - Pain): The frustration, waste, or cost of the old way
Slide 4 (The Change): "Then I started using [PRODUCT]" - simple, no hype
Slide 5 (After - Result): The measurable improvement. Use specific numbers or clear outcomes.
Slide 6 (CTA): "Try it yourself. [CTA TEXT]"

Rules:
- Be specific. Numbers and timelines beat vague claims.
- The "before" should be universally relatable in the target audience.
- The "after" should be believable, not exaggerated.
- Keep text short. Max 15 words per slide.
- [BRAND VOICE DESCRIPTION] tone.
- Do not use em-dashes.
```

---

## Template 4: Relatable Pain Point (6 slides)

Best for: Content about universal frustrations that drives comments and shares.

```
Create a 6-slide TikTok photo carousel about a relatable frustration that [PRODUCT NAME] solves.

Pain point: [SPECIFIC FRUSTRATION that the target audience experiences]

Slide 1 (Hook): "[POV or 'That moment when' statement that everyone in the audience relates to]"
Slide 2 (The Frustration): Expand on the feeling. Make it vivid and specific.
Slide 3 (It Gets Worse): The consequences, the spiral, or the embarrassing moment
Slide 4 (Plot Twist): "But then I found [PRODUCT]" or "There is actually a fix for this"
Slide 5 (The Fix): How [PRODUCT] specifically solves this exact pain point. [FEATURE]
Slide 6 (CTA): Soft CTA. "Changed my life honestly. [CTA TEXT]"

Rules:
- The first 3 slides should feel like a meme or relatable rant
- The product introduction should feel like sharing a genuine discovery with a friend
- Use humor where it fits naturally for the brand voice
- Keep text short. Max 15 words per slide.
- [BRAND VOICE DESCRIPTION] tone.
- Do not use em-dashes.
```

---

## Template 5: POV / Lifestyle (5 to 6 slides)

Best for: Aspirational or relatable scenario content that builds the brand.

```
Create a [5-6]-slide TikTok photo carousel with a POV scenario related to [PRODUCT NAME].

Scenario: [ASPIRATIONAL or RELATABLE SCENARIO that the product enables]

Slide 1 (Hook): "POV: You [scenario that hooks the viewer]"
Slide 2 (Scene): Set the scene with a specific, vivid detail
Slide 3 (Experience): Show the experience unfolding naturally
Slide 4 (Payoff): The satisfying moment or positive outcome
Slide 5 (Product): [PRODUCT] shown naturally as part of the lifestyle (not the focus)
Slide 6 (Optional CTA): Soft CTA or just let it end naturally

Rules:
- Focus on the experience, not the product
- The product should feel woven into the lifestyle, not selling
- Keep it aspirational but believable
- Keep text short. Max 15 words per slide.
- [BRAND VOICE DESCRIPTION] tone.
- Do not use em-dashes.
```

---

## Template 6: Quick Feature Spotlight (4 to 5 slides)

Best for: Showcasing one specific product feature quickly.

```
Create a [4-5]-slide TikTok photo carousel spotlighting a feature of [PRODUCT NAME].

Feature: [FEATURE NAME and what it does]

Slide 1 (Hook): "[Compelling question or claim about the feature's benefit]"
Slide 2 (Problem): The old way of doing this (manual, tedious, forgettable, expensive)
Slide 3 (Demo): How the feature works in one simple sentence
Slide 4 (Result): What changes when you use it. Specific outcome.
Slide 5 (CTA): "[CTA TEXT]" (optional, can end at 4)

Rules:
- Focus on ONE feature only
- Show the benefit, not the feature list
- Keep it snappy. This format works best at 4 to 5 slides max.
- Conversational, zero jargon.
- Do not use em-dashes.
```

---

## Prompt Writing Rules

These rules apply to every prompt sent to the genviral API:

1. **Include the exact hook text in slide 1.** Do not let the AI rephrase your hook. The hook is deliberate and tested.

2. **Set the tone explicitly.** Include a phrase like "casual, conversational, like talking to a friend" to prevent corporate-sounding output. Match `workspace/context/brand-voice.md`.

3. **Cap the word count.** Always include "Max 15 words per slide" or similar constraint.

4. **Be specific in the story arc.** The more detail you provide about each slide's purpose, the better the output.

5. **Match the prompt to the pack, and inspect pack images first.** Do not rely only on pack name. Fetch the pack, read image metadata (descriptions + keywords), and use vision tools where needed for readability assessment. Align slide scenarios with the strongest visuals.

6. **Assign visuals slide-by-slide using `pinned_images`.** Explicitly decide which image best supports each slide's hook/body text, then pass `pinned_images` in `slide_config` so the server uses your choices. Without `pinned_images`, the server picks randomly and your visual analysis is wasted.

7. **Always review before rendering.** Check each slide's text before calling render. Fix weak slides with update or regenerate-slide.

8. **Never send placeholders to the API.** Every bracket must be replaced with real content before generating.

9. **No em-dashes.** Instruct the AI explicitly: "Do not use em-dashes."

10. **Track the hook you use.** After posting, log the hook text, hook category, and CTA to `workspace/performance/hook-tracker.json`. The tracker is how you learn what actually works. If you never log hooks, you are flying blind -- you will repeat failed hooks and underuse winners. See `docs/references/analytics-loop.md` for the full process.
