# Hook Formulas

This file documents the underlying hook patterns. These are templates, not finished hooks. The agent generates specific hooks by combining a formula with the product context from `context/product.md`.

Each formula includes:
- The pattern with placeholders
- Why it works psychologically
- Structural guidelines
- Placeholder examples

Replace `[PRODUCT]` with the product name, `[PERSON]` with a relatable character, `[PROBLEM]` with a specific pain point, and `[FEATURE]` with a product capability.

## Formula 1: Person + Conflict

**Pattern:**
`[PERSON] said [DOUBT or OBJECTION about PROBLEM]. So I showed them [PRODUCT / what the product does]. [REACTION or RESULT].`

**Slide structure (6 slides):**
1. "[PERSON] said [doubt]..."
2. Why they thought that. The context for the objection.
3. "So I showed them [PRODUCT]" or "Then I opened the app"
4. The specific [FEATURE] that solved it, shown simply
5. Their reaction or the result
6. Soft CTA (link in bio, try it free)

**Why it works:**

This formula taps into three psychological drivers at once. First, interpersonal tension creates immediate curiosity. People want to see conflicts resolved. Second, the "doubter gets proven wrong" arc is deeply satisfying. Viewers project themselves into the story. Third, naming a specific person (my roommate, my mom, my trainer) makes the story feel real and lived-in, not scripted.

The key is specificity. "My coworker said [specific objection]" is dramatically stronger than "People think [generic doubt]." Naming the person and the exact objection creates a micro-story that hooks attention in under one second.

**Placeholder examples:**
- "My [PERSON] said [DOUBT about PROBLEM]..."
- "My roommate said [nobody needs PRODUCT]..."
- "My mom said [PROBLEM is not worth solving]..."
- "My trainer said [I would never stick to FEATURE]..."
- "My coworker said [the old way is good enough]..."

**Performance notes:**
This is consistently the highest-performing formula across niches. Prioritize this category at 40% of total content mix. Vary the [PERSON] and [OBJECTION] to avoid repetition.

---

## Formula 2: Educational / Tips

**Pattern:**
`[NUMBER] [THINGS/MISTAKES/HACKS] about [TOPIC related to PROBLEM] that [SURPRISING CLAIM]`

**Slide structure (6 slides):**
1. The hook claim (make it surprising or counterintuitive)
2. Tip 1 with brief explanation
3. Tip 2 with brief explanation
4. Tip 3 with brief explanation
5. "Or just use [PRODUCT] to handle all of this for you" (natural transition)
6. CTA (link in bio)

**Why it works:**

Educational content triggers the "I should save this" response. People bookmark tips they find useful, and saves are one of the strongest signals in TikTok's algorithm. The numbered format sets a clear expectation ("5 things" tells the viewer exactly what they are getting) which reduces the decision cost of engaging.

The product introduction on slide 5 feels earned rather than intrusive. The viewer already received value, so the product mention feels like a helpful addition rather than an ad.

**Placeholder examples:**
- "[NUMBER] [THINGS] about [TOPIC] you are doing wrong"
- "5 mistakes people make with [PROBLEM]"
- "The [AMOUNT] [PROBLEM] hack nobody talks about"
- "Stop [BAD HABIT related to PROBLEM]. Here is what to do instead."
- "[NUMBER] signs you need [PRODUCT] (and don't even know it)"

**Performance notes:**
Strong for building saves and follows. Works best when the tips are genuinely surprising or counterintuitive. Avoid obvious advice. The more specific and actionable each tip is, the better.

---

## Formula 3: Before / After

**Pattern:**
`[METRIC or SITUATION] before [PRODUCT] vs after. [SPECIFIC IMPROVEMENT with numbers or timeline].`

**Slide structure (6 slides):**
1. The transformation claim (before vs. after)
2. The "before" state in vivid, specific detail
3. The pain or cost of the "before" state (make them feel it)
4. "Then I started using [PRODUCT]" (simple, no hype)
5. The "after" state with specific, believable improvements
6. CTA (try it yourself, link in bio)

**Why it works:**

Transformation content is inherently shareable because it promises change. The brain is wired to pay attention to contrast. Before/after framing creates a clear narrative arc in just two states, making it cognitively easy to process.

Specificity is critical. "[AMOUNT] to [SMALLER AMOUNT]" is far more compelling than "I saved money." Real numbers, real timelines, and real situations build credibility. The transformation should feel achievable, not miraculous. Exaggeration triggers skepticism; understated honesty triggers trust.

**Placeholder examples:**
- "My [METRIC] before [PRODUCT] vs after"
- "How I went from [BAD STATE] to [GOOD STATE] with one change"
- "[TIME PERIOD] of using [PRODUCT]. Here are the results."
- "What [PROBLEM AREA] looked like before vs. after [PRODUCT]"
- "I tracked [METRIC] for 30 days. Here is what happened."

**Performance notes:**
Works especially well when you can include real numbers or screenshots. Pair with specific timeframes ("after 2 weeks", "in 30 days") to make the claim tangible.

---

## Formula 4: Relatable Pain Point

**Pattern:**
`That moment when [UNIVERSAL FRUSTRATION related to PROBLEM]... [humorous or empathetic expansion] [Plot twist: there is actually a fix]`

**Slide structure (6 slides):**
1. The pain point hook (POV, "that moment when", or "when you realize")
2. Expand on the frustration. Make it vivid and specific.
3. It gets worse (the consequences or the spiral)
4. "But then I found [PRODUCT]" or "There is actually a fix for this"
5. How [PRODUCT] specifically solves this exact pain point
6. Soft CTA ("Changed my life honestly. Link in bio.")

**Why it works:**

Relatable content drives social sharing. When people see their own frustration articulated perfectly, they tag friends, comment "this is literally me," and share to their stories. This organic engagement signals the algorithm to push the content further.

The humor or empathy in slides 1 through 3 builds rapport. The viewer feels understood. When the product appears in slide 4, it feels like a genuine discovery being shared friend-to-friend, not a sales pitch.

**Placeholder examples:**
- "That moment when [COMMON FRUSTRATION with PROBLEM]..."
- "POV: You [EMBARRASSING or RELATABLE SITUATION related to PROBLEM]"
- "When you realize [SURPRISING NEGATIVE CONSEQUENCE of PROBLEM]"
- "Nobody talks about [HIDDEN COST or ANNOYANCE of PROBLEM]"
- "Why does [COMMON FRUSTRATION] still happen in [CURRENT YEAR]?"

**Performance notes:**
This formula drives the most comments and shares. Best used when the pain point is truly universal in the target audience. Humor helps but is not required. Authentic empathy works just as well.

---

## Formula 5: POV / Lifestyle

**Pattern:**
`POV: You [ASPIRATIONAL or RELATABLE SCENARIO that PRODUCT enables or relates to]`

**Slide structure (5 to 6 slides):**
1. "POV: You [scenario]" (place the viewer in the scene)
2. Set the scene with a specific, vivid detail
3. Show the experience unfolding
4. The payoff or satisfying moment
5. Subtle product presence (PRODUCT shown naturally in the scenario)
6. Optional: soft CTA or just let it end

**Why it works:**

POV content places the viewer inside the experience rather than observing it from outside. This first-person framing increases emotional engagement and makes the viewer mentally simulate the scenario. When the simulation is pleasant or aspirational, it creates desire. When it is relatable, it creates connection.

This formula works best when the product is woven into the lifestyle naturally rather than being the focus. The product should feel like a natural part of a desirable or relatable life, not the point of the post.

**Placeholder examples:**
- "POV: You finally [POSITIVE OUTCOME related to PRODUCT]"
- "POV: You [DAILY ROUTINE that is better because of PRODUCT]"
- "POV: It is Sunday morning and [RELAXED SCENARIO enabled by PRODUCT]"
- "POV: Your friend asks how you [ACHIEVEMENT related to PRODUCT]"
- "POV: You stopped [BAD HABIT] and now [POSITIVE RESULT]"

**Performance notes:**
Lower direct conversion but excellent for brand building and follower growth. Use at 10% of the content mix. Best paired with aesthetic visuals and trending audio.

---

## How to Generate New Hooks

When the hook library needs refreshing:

1. Read `context/product.md` to understand the product, audience, and features.
2. Read `context/brand-voice.md` to match the tone.
3. Pick a formula from this file.
4. Replace placeholders with specific, product-relevant details.
5. Test the hook against these criteria:
   - Does it create curiosity in under 1 second?
   - Would a real person say this?
   - Is the [PERSON] or [SITUATION] specific, not generic?
   - Does it pass the "would I stop scrolling for this?" test?
6. Generate 3 to 5 variants per formula and pick the strongest.
7. Add to `hooks/library.json` with status "new."

Use `prompts/hooks.md` for detailed brainstorming prompts to generate hooks at scale.

## Hook Quality Criteria

Every hook should pass ALL of these checks:

- **Specific.** Names a real type of person or situation, not a vague "people."
- **Curiosity-driven.** The viewer needs to see the next slide to resolve the tension.
- **Human-sounding.** Reads like something someone would actually say out loud.
- **One idea.** The hook is about one thing, not two or three.
- **Under 20 words.** For slide 1, shorter is almost always better.
- **No jargon.** No corporate language, no buzzwords, no marketing speak.
- **No em-dashes.** Use periods, commas, or ellipses instead.
