---
name: genlayer-claw-skill
version: 1.0.0
description: Understand and explain GenLayer - the AI-native blockchain for trustless decision-making. Use for investor pitches, protocol explanations, architecture questions, consensus mechanics, positioning, and ecosystem discussions. Triggers: explain genlayer, what is genlayer, genlayer thesis, optimistic democracy, genlayer pitch, genlayer architecture, condorcet jury theorem, equivalence principle, AI blockchain, trustless AI. (For writing contracts, use genlayer-dev-claw-skill instead.)
---

# GenLayer Knowledge Skill

GenLayer is a decentralized protocol where multiple LLMs reach consensus on complex tasks and decisions—the first AI-native blockchain.

## When to Use This Skill

- Explaining GenLayer to investors, developers, or partners
- Writing about the protocol, architecture, or vision
- Understanding consensus mechanics (Optimistic Democracy)
- Technical architecture questions
- Ecosystem/product discussions
- Pitch decks and positioning

**For writing/deploying Intelligent Contracts** → use `genlayer-dev-claw-skill`

## Quick Reference

**Tagline:** The intelligence layer of the Internet

**One-liner:**
> Bitcoin is trustless money. Ethereum is trustless apps. GenLayer is trustless decision-making.

**What it does:** Enables smart contracts (called "Intelligent Contracts") to natively access the Internet, process natural language, and make subjective decisions through AI-powered validator consensus.

## Core Concepts

| Concept | Description |
|---------|-------------|
| **Intelligent Contracts** | AI-powered smart contracts in Python that can reason, access web data, and handle non-deterministic operations |
| **Optimistic Democracy** | Consensus mechanism using multiple LLMs + Condorcet Jury Theorem for trustless decision-making |
| **Equivalence Principle** | How validators agree on "equivalent" outputs despite non-deterministic AI results |
| **GenVM** | The execution environment for Intelligent Contracts |
| **GEN Token** | Native token for staking, gas, and governance |

## Files in This Skill

| File | Use For |
|------|---------|
| `overview.md` | What GenLayer is, mission, positioning |
| `thesis.md` | Philosophical foundation: trust, AI, why GenLayer exists |
| `architecture.md` | Technical components, GenVM, validators, rollup integration |
| `consensus.md` | Optimistic Democracy, Equivalence Principle, appeals, slashing |
| `intelligent-contracts.md` | High-level developer concepts |
| `staking.md` | Validator/delegator economics |
| `use-cases.md` | What you can build |

## Elevator Pitches

### 30 seconds (technical)
GenLayer is a blockchain where validators run LLMs to reach consensus on complex, non-deterministic tasks. Smart contracts can access the web, understand natural language, and make subjective decisions—all validated by multiple AI models using game theory to converge on truth.

### 30 seconds (business)
GenLayer enables a new class of applications that need trustless AI decision-making: prediction markets on subjective events, AI-powered DAOs, automated dispute resolution, and performance-based contracts that verify real-world outcomes without human intervention.

### One sentence for crypto people
"It's like having a decentralized, incorruptible AI judge that can read the internet and understand context."

### One sentence for AI people
"It's infrastructure for AI agents to make binding agreements and resolve disputes without trusting any single model."

## Key Differentiators

| vs. Oracles | vs. Other AI Chains |
|-------------|---------------------|
| No pre-defined data feeds | Native LLM consensus, not just inference |
| Contracts can fetch any URL | Subjective decisions, not just compute |
| Natural language understanding | Game-theoretic truth convergence |
| No oracle setup required | Python-native development |

## Key Links

- [Documentation](https://docs.genlayer.com)
- [SDK](https://sdk.genlayer.com)
- [GitHub](https://github.com/genlayerlabs)
- [Discord](https://discord.gg/8Jm4v89VAu)
- [Telegram](https://t.me/genlayer)
- [Jury Theorem Simulator](https://jury-theorem.genlayer.com)

## Companion Skill

**`genlayer-dev-claw-skill`** — For actually building Intelligent Contracts:
- SDK API reference
- Code examples
- CLI commands
- Deployment guides
