# genlayer-claw-skill

A Claw skill for understanding and explaining GenLayer—the first AI-native blockchain for trustless decision-making.

## Purpose

This skill helps AI assistants explain GenLayer to:
- Investors and partners
- Developers exploring the ecosystem
- Anyone curious about the protocol

**For writing/deploying Intelligent Contracts**, use the companion skill: [genlayer-dev-claw-skill](https://github.com/acastellana/genlayer-dev-claw-skill)

## What's Inside

| File | Description |
|------|-------------|
| `SKILL.md` | Quick reference, elevator pitches, when to use |
| `overview.md` | What GenLayer is, how it works, why it matters |
| `thesis.md` | The philosophical foundation: trust, AI, and mechanism design |
| `architecture.md` | GenVM, validators, rollup integration, network parameters |
| `consensus.md` | Optimistic Democracy, Equivalence Principle, appeals, slashing |
| `intelligent-contracts.md` | High-level concepts for developers |
| `staking.md` | Validator/delegator economics and operations |
| `use-cases.md` | Prediction markets, dispute resolution, AI DAOs |

## Quick Summary

> **Bitcoin** is trustless money.  
> **Ethereum** is trustless apps.  
> **GenLayer** is trustless decision-making.

GenLayer is a decentralized protocol where multiple LLMs reach consensus on complex tasks. Intelligent Contracts can:

- Process natural language
- Access real-time web data
- Make subjective decisions
- Handle non-deterministic operations

All validated by multiple AI models using game theory to converge on truth.

## Installation

### Claw CLI
```bash
claw skill add https://github.com/acastellana/genlayer-claw-skill
```

### Manual
Clone to your skills directory and reference in your agent config.

## Related

- **Companion skill:** [genlayer-dev-claw-skill](https://github.com/acastellana/genlayer-dev-claw-skill) — For building contracts
- **Docs:** https://docs.genlayer.com
- **GitHub:** https://github.com/genlayerlabs

## License

MIT
