#!/usr/bin/env bash
set -euo pipefail

# Run Gemini CLI in a pseudo-TTY for more reliable non-interactive execution.
# Usage:
#   gemini_prompt.sh "Search the web: ..."

PROMPT=${1:-}
if [[ -z "${PROMPT}" ]]; then
  echo "Usage: $0 \"<prompt>\"" >&2
  exit 2
fi

GEMINI_BIN="${GEMINI_BIN:-$HOME/.npm-global/bin/gemini}"

# 'script' allocates a pseudo-terminal; /dev/null avoids creating a typescript file.
script -q -c "${GEMINI_BIN} -p \"${PROMPT//\"/\\\"}\"" /dev/null
