---
name: gemini-web-search
description: Use Gemini CLI (@google/gemini-cli) to do web search / fact-finding and return a sourced summary. Use when the user asks “why did X happen today”, “what’s the latest news”, “search the web”, “find sources/links”, or any task requiring up-to-date info. Prefer this over other search tools when Gemini is available but slow; run it with a TTY, wait longer, and verify source quality.
---

# Gemini Web Search

Use Gemini CLI to search the web and produce a concise, sourced answer.

## Quick workflow

1) **Formulate a tight query**
- Include: entity + ticker/name + date/time window + what you need (%, $, cause, quotes, links)
- Example: `PayPal (PYPL) fell Feb 4 2026: % change, $ change, main catalyst(s), 3 sources`

2) **Run Gemini CLI with a TTY and long timeout**
Gemini CLI can hang or be slow without a pseudo-TTY.

Preferred (OpenClaw tool call):
- Use `functions.exec` with `pty: true`
- Use `timeout` 300–600s (longer for heavy searches)
- Use `yieldMs` ~10000 then `process.poll` until completion

Command template:
- `~/.npm-global/bin/gemini -p "<prompt>"`

If `pty:true` still behaves poorly, use a pseudo-tty wrapper:
- `script -q -c "~/.npm-global/bin/gemini -p \"<prompt>\"" /dev/null`

3) **Extract the answer in a structured way**
Return:
- The key numeric facts (e.g., % move, $ move, close/intraday)
- 2–4 bullets of the main catalyst(s)
- **Links** (always)

4) **Quality control (mandatory)**
- Prefer: company IR/SEC filing, Reuters, Bloomberg, WSJ/FT, CNBC, reputable outlets.
- Avoid relying on low-quality finance blogs/SEO sites.
- If sources conflict or look unreliable: say so and ask user for a screenshot/link, or re-run with a stricter prompt.

## Prompts that work well

- **Fast triage**:
  `Search the web: <topic>. Give 3 bullets + 2 reputable links.`

- **Market move**:
  `Search the web: Why did <TICKER> move today (<date>)? Provide exact % and $ move (close + intraday if available) and the main catalyst(s). Cite sources with links.`

- **Force better sources**:
  `Search the web and prioritize Reuters/company IR/SEC filing. If you cannot find them, say so. Topic: <...>. Provide links.`

## Failure modes & fixes

- **Gemini prints “I will search…” then stalls**
  - Wait longer (it can be slow).
  - Ensure TTY: run with `pty:true` or `script -q -c ... /dev/null`.

- **Output has suspicious claims (e.g., odd CEO news)**
  - Re-run with: “use Reuters/company IR/SEC filing only; otherwise say unknown”.
  - Cross-check with at least 2 independent reputable sources.

- **Need numbers but sources don’t show them**
  - Ask user for the quote/screenshot from their market data app and reconcile.

## Local setup notes

- Gemini CLI binary: `~/.npm-global/bin/gemini`
- Auth: already completed by Jiajie (should work without re-login)
