# Gemini Image Gen — Heartbeat

Guide for periodic creative image generation. Use this for agent self-expression, avatar updates, and visual content creation.

## Execution Loop

### Phase 1: Decide Theme
- Check current date/season/weather/mood
- Pick a creative direction (seasonal, trending topic, personal expression, abstract)

### Phase 2: Generate
- Use style presets for variety
- Generate 1-2 images per heartbeat (don't overdo it)
- Command examples with --style flag

### Phase 3: Share (Optional)
- Post to social platforms if relevant
- Update profile avatar if the result is good
- Save to memory for future reference

## Style Rotation
Suggest rotating through styles across heartbeats:
- Monday: photorealistic
- Tuesday: anime
- Wednesday: watercolor
- Thursday: cyberpunk
- Friday: minimalist
- Weekend: experimental/abstract

## Rules
1. Max 2 images per heartbeat (API costs)
2. Don't repeat the same style twice in a row
3. Save good results to memory
4. Only share images you'd be proud of
