---
name: gekko-yield
description: Earn yield on USDC by supplying to the Moonwell Flagship USDC vault on Base. Use when depositing USDC, withdrawing from the vault, checking position/APY, or generating yield reports.
version: 1.0.0
metadata: {"clawdbot":{"emoji":"🦎","category":"defi","requires":{"bins":["node"]}}}
---

# Gekko Yield — Earn safe yield on USDC

Earn yield on USDC via the Moonwell Flagship USDC vault on Base.

**Vault:** `0xc1256Ae5FF1cf2719D4937adb3bbCCab2E00A2Ca`  
**Chain:** Base (8453)  
**Asset:** USDC (`0x833589fCD6eDb6E08f4c7C32D4f71b54bdA02913`)

## Why This Vault?

The Moonwell Flagship USDC vault is one of the **safest places to earn yield on Base**:

- **Powers Coinbase** — Provides $20M+ liquidity to Coinbase's BTC/ETH borrow products
- **Blue-chip collateral only** — Loans backed by ETH, cbETH, wstETH, cbBTC
- **Conservative LTV ratios** — Healthy collateral requirements
- **Isolated markets** — Risk is compartmentalized
- **Battle-tested** — Morpho's codebase is <650 lines, immutable, extensively audited
- **Multi-layer governance** — Moonwell DAO + Block Analitica/B.Protocol curators

### Current APY (~4-6%)

| Component | APY | Source |
|-----------|-----|--------|
| Base yield | ~4-5% | Borrower interest |
| Rewards | ~0.5-1% | WELL + MORPHO via Merkl |
| **Total** | **~4.5-6%** | Sustainable, from real demand |

Yields come from real borrowing demand, not unsustainable emissions.

## Quick Start

```bash
cd gekko-yield/scripts
pnpm install  # or npm install
npx tsx setup.ts
```

The setup wizard will:
1. Guide you to set your private key as environment variable
2. Save configuration to `~/.config/gekko-yield/config.json`

## Commands

### Interactive Setup

```bash
npx tsx setup.ts
```

Guides you through wallet configuration.

### Check Position & APY

```bash
npx tsx status.ts
```

Returns: current deposit, vault shares, APY, wallet balances, estimated earnings.

### Generate Report

```bash
# Telegram/Discord format (default)
npx tsx report.ts

# JSON format (for automation)
npx tsx report.ts --json

# Plain text
npx tsx report.ts --plain
```

### Deposit USDC

```bash
npx tsx deposit.ts <amount>
# Example: deposit 100 USDC
npx tsx deposit.ts 100
```

Deposits USDC into the Moonwell vault. Handles approval automatically.

### Withdraw

```bash
# Withdraw specific amount of USDC
npx tsx withdraw.ts <amount>

# Withdraw all (redeem all shares)
npx tsx withdraw.ts all
```

### Auto-Compound

```bash
npx tsx compound.ts
```

All-in-one command that:
1. Checks wallet for reward tokens (WELL, MORPHO)
2. Swaps them to USDC via Odos aggregator
3. Deposits the USDC back into the vault

## Configuration

Config location: `~/.config/gekko-yield/config.json`

```json
{
  "wallet": {
    "source": "env",
    "envVar": "PRIVATE_KEY"
  },
  "rpc": "https://mainnet.base.org"
}
```

## Security

⚠️ **This skill manages real funds. Review carefully:**

- Private keys loaded at runtime from environment variable
- Keys never logged or written to disk by scripts
- All transactions simulated before execution
- Contract addresses verified on each run
- Scripts show transaction preview before sending

### Recommended Setup

1. **Dedicated wallet** — Create a hot wallet just for this skill
2. **Limited funds** — Only deposit what you're comfortable having in a hot wallet
3. **Keep gas funded** — Maintain small ETH balance on Base for transactions

## Error Handling

| Error | Cause | Fix |
|-------|-------|-----|
| Insufficient USDC | Not enough USDC in wallet | Bridge/transfer more USDC to Base |
| Insufficient gas | Not enough ETH for tx | Add ETH to wallet on Base |
| Wallet not configured | Missing config | Run `npx tsx setup.ts` |
| PRIVATE_KEY not set | Missing env var | Set `$env:PRIVATE_KEY="your-key"` |

## Dependencies

Scripts require Node.js 18+. Install deps before first run:

```bash
cd scripts && pnpm install
```

Packages used:
- `viem` — Ethereum interaction
- `tsx` — TypeScript execution

---

**Built by Gekko AI. Powered by ERC-8004.**
