# Geekbench 技能

## 核心原则
- **不要依赖模型知识**：模型训练数据有时效性，最新产品信息需实时搜索
- **多方信源验证**：通过搜索获取最新发布信息
- **实时确认**：每次查询都重新搜索确认

## 确定最新旗舰流程

### Step 1: 搜索最新信息
- **搜索词**: "品牌 + 最新旗舰 + 发布" 或 "品牌 + 2025 旗舰"
- **示例**: "OPPO 最新旗舰 发布"
- **目标**: 获取最新已发布的产品名称

### Step 2: 验证发布时间
- 确认产品是否已正式发布
- 排除"即将发布"、"谍照"、"传闻"等未发布信息

### Step 3: 搜索跑分
1. 使用 "产品名 + geekbench" 搜索
2. 获取内部型号
3. 用内部型号查询详细跑分

### Step 4: 分析验证
1. 按Geekbench版本分组统计
2. 验证数据与发布时间的一致性
3. 标记异常数据（测试版本、样本过少等）

## 示例：OPPO Find X9 系列

### 错误做法（依赖模型知识）
- 模型知识: Find X8 (2024年发布)
- 结果: 返回过时信息

### 正确做法（实时搜索）
1. 搜索 "OPPO 最新旗舰 发布"
2. 找到: Find X9 系列（2025年发布）
3. 搜索 "OPPO Find X9 geekbench"
4. 获取内部型号和跑分数据

## 常见内部型号格式
- OPPO: 需搜索获取Find X9型号
- 荣耀: 需搜索获取Magic 9型号
- 小米: 需搜索获取小米18型号
- 苹果: 需搜索获取iPhone 17/18型号

## 注意事项
- 不同Geekbench版本分数不可直接比较
- 优先使用 Geekbench 6.5.0 数据
- 检测 Single-Core > 3000 为高分设备
- 未发布产品的跑分可能是早期测试数据
