---
name: gedcom-explorer
description: Generate an interactive family tree dashboard from any GEDCOM (.ged) file. Creates a single-file HTML app with 5 tabs (Dashboard, Family Tree, People, Timeline, Daily Alerts), search, person modals, charts, and "On This Day" events. Use when asked to visualize genealogy data, explore family history, build a family tree viewer, or work with GEDCOM files. Triggers on "family tree", "genealogy", "GEDCOM", "ancestors", "family explorer", "family history dashboard".
---

# GEDCOM Explorer

Parse any GEDCOM file and generate a self-contained interactive HTML dashboard.

## Quick Start

```bash
python3 scripts/build_explorer.py <input.ged> [output.html] [--title "Title"] [--subtitle "Subtitle"]
```

### Examples

```bash
# Basic — outputs family-explorer.html in current directory
python3 scripts/build_explorer.py ~/my-family.ged

# Custom output path and title
python3 scripts/build_explorer.py ~/my-family.ged ~/Desktop/hart-family.html \
  --title "Hart Family Tree" --subtitle "Six generations of history"

# Demo with bundled US Presidents data
python3 scripts/build_explorer.py assets/demo-presidents.ged presidents.html \
  --title "Presidential Family Explorer" --subtitle "US Presidents & Their Ancestors"
```

## Features

- **Dashboard** — Stats grid (people, families, places, generations), On This Day events, top surnames, geographic origins, people by century, party breakdown (for presidential data)
- **Family Tree** — Interactive tree visualization with zoom/pan, select any person as root, color-coded by gender/president status
- **People** — Searchable/filterable directory with gender and president filters, pagination, click for full detail modal
- **Timeline** — Chronological events (births, deaths, marriages) with filters and search
- **Daily Alerts** — Today's anniversaries, random ancestor spotlight, fun facts
- **Person Modal** — Full detail view with parents, spouses, children (all clickable links)
- **Global Search** — Search across all tabs by name, place, or year

## How It Works

`build_explorer.py` parses the GEDCOM, extracts all individuals + families, computes stats, and embeds everything as inline JSON in a single HTML file. No server needed — just open the HTML.

Auto-detects US Presidents from OCCU (occupation) fields. Works with any GEDCOM; presidential features simply won't appear if no president data exists.

## GEDCOM Sources

Users can export `.ged` files from:
- **Ancestry.com** → Tree Settings → Export Tree
- **FamilySearch.org** → Download GEDCOM
- **MyHeritage** → Family Tree → Export → GEDCOM
- Any genealogy software (Gramps, RootsMagic, Legacy, etc.)

## Demo Data

`assets/demo-presidents.ged` — Public domain US Presidents GEDCOM (2,322 people, 1,115 families, 44 presidents). Source: webtreeprint.com.

## Serving Locally

```bash
cd /path/to/output/dir
python3 -m http.server 8899
# Open http://localhost:8899/family-explorer.html
```

## Extending

The generated HTML is fully self-contained. To customize:
- Edit CSS variables in `:root` for theming
- The dashboard adapts to whatever data is in the GEDCOM — no presidential data required
- For OpenClaw cron integration: parse GEDCOM daily events and send "On This Day" notifications via Telegram
